"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaChangesReviewModal = SchemaChangesReviewModal;
exports.getChanges = getChanges;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactField = require("@kbn/react-field");
var _streamsSchema = require("@kbn/streams-schema");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _reactHooks = require("@kbn/react-hooks");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _use_kibana = require("../../../hooks/use_kibana");
var _errors = require("../../../util/errors");
var _constants = require("./constants");
var _utils = require("./utils");
var _field_result = require("./field_result");
var _field_status = require("./field_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/schema_changes_review_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SchemaChangesReviewModal({
  fields,
  streamType,
  definition,
  storedFields,
  submitChanges,
  onClose
}) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  const changes = _react.default.useMemo(() => getChanges(fields, storedFields), [fields, storedFields]);
  const [{
    loading
  }, handleSubmit] = (0, _useAsyncFn.default)(async () => {
    await submitChanges();
    onClose();
  }, [submitChanges, onClose]);
  const [hasSimulationErrors, setHasSimulationErrors] = _react.default.useState(false);
  const [simulationError, setSimulationError] = _react.default.useState(null);
  const [isSimulating, setIsSimulating] = _react.default.useState(false);
  (0, _react.useEffect)(() => {
    async function simulate() {
      setIsSimulating(true);
      setSimulationError(null);
      const mappedFields = changes.filter(field => field.status === 'mapped').map(field => ({
        ...(0, _utils.convertToFieldDefinitionConfig)(field),
        name: field.name
      }));
      try {
        const simulationResults = await streamsRepositoryClient.fetch('POST /internal/streams/{name}/schema/fields_simulation', {
          signal,
          params: {
            path: {
              name: definition.stream.name
            },
            body: {
              field_definitions: mappedFields
            }
          }
        });
        if (simulationResults.status === 'failure') {
          setHasSimulationErrors(true);
          setSimulationError(simulationResults.simulationError);
        }
      } catch (err) {
        setHasSimulationErrors(true);
        setSimulationError((0, _errors.getFormattedError)(err).message);
      } finally {
        setIsSimulating(false);
      }
    }
    simulate();
  }, [changes, streamsRepositoryClient, signal, definition.stream.name]);
  const confirmChangesTitle = _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.title', {
    defaultMessage: 'Confirm changes'
  });

  // Check if any field has a source or result value
  const hasSource = _react.default.useMemo(() => changes.some(field => field.source && !field.esType), [changes]);
  const hasResult = _react.default.useMemo(() => changes.some(field => field.result), [changes]);
  const fieldColumns = _react.default.useMemo(() => [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.tableColumnField', {
      defaultMessage: 'Field'
    }),
    width: '40%',
    render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: name,
      anchorClassName: (0, _css.css)`
              width: 100%;
            `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      tabIndex: 0,
      className: (0, _css.css)`
                overflow: hidden;
                text-overflow: ellipsis;
                white-space: nowrap;
              `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 13
      }
    }, name))
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.tableColumnType', {
      defaultMessage: 'Type'
    }),
    width: '20%',
    truncateText: true,
    render: (type, field) => {
      // Prioritize showing esType if available and different from our supported type
      if (field.esType && (!type || type === 'system')) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 174,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
          type: field.esType,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 175,
            columnNumber: 17
          }
        }), field.esType);
      }
      if (!type || field.status === 'unmapped') {
        // Only show <dynamic> for classic streams with unmapped fields
        if (streamType === 'classic') {
          const dynamicText = _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.dynamicText', {
            defaultMessage: 'Dynamic'
          });
          return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: "hollow",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 190,
              columnNumber: 22
            }
          }, dynamicText);
        }
        // For wired streams, don't show <dynamic> for unmanaged fields
        return null;
      }

      // Handle unknown types gracefully
      const typeInfo = _constants.FIELD_TYPE_MAP[type];
      const typeLabel = typeInfo ? typeInfo.label : type;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
        type: type,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 15
        }
      }), typeLabel);
    }
  }, {
    field: 'status',
    name: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.tableColumnStatus', {
      defaultMessage: 'Status'
    }),
    render: (status, field) => {
      return /*#__PURE__*/_react.default.createElement(_field_status.FieldStatusBadge, {
        status: status,
        uncommitted: field.uncommitted,
        streamType: streamType,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 13
        }
      });
    }
  }, ...(hasResult ? [{
    field: 'result',
    name: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.tableColumnResult', {
      defaultMessage: 'Result'
    }),
    render: (result, field) => {
      if (!result) return null;
      return /*#__PURE__*/_react.default.createElement(_field_result.FieldResultBadge, {
        result: result,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 24
        }
      });
    }
  }] : []), ...(hasSource ? [{
    field: 'source',
    name: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.tableColumnSource', {
      defaultMessage: 'Source'
    }),
    truncateText: true,
    render: (source, field) => {
      // Don't show source for existing fields (those that have esType)
      if (field.esType) {
        return null;
      }
      if (!source) return null;
      const sourceLabels = {
        ecs: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.sourceLabel.ecs', {
          defaultMessage: 'ECS'
        }),
        otel: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.sourceLabel.otel', {
          defaultMessage: 'OTel'
        })
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "default",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 19
        }
      }, sourceLabels[source] || source);
    }
  }] : [])], [hasResult, hasSource, streamType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    maxWidth: 800,
    "aria-label": confirmChangesTitle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 9
    }
  }, confirmChangesTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 7
    }
  }, _streamsSchema.Streams.WiredStream.GetResponse.is(definition) ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.affectsAllStreamsCalloutTitle', {
      defaultMessage: 'Schema edits affect all dependent streams.'
    }),
    iconType: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 11
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.fieldsWillBeUpdatedText', {
    defaultMessage: 'Some fields below will be updated.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 9
    }
  }), hasSimulationErrors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.simulationErrorCalloutTitle', {
      defaultMessage: 'Some fields are failing when simulating ingestion.'
    }),
    iconType: "warning",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 13
    }
  }, simulationError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: changes,
    columns: fieldColumns,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "streamsAppSchemaChangesReviewModalCancelButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.schemaEditor.confirmChangesModal.cancelButton",
    defaultMessage: "Cancel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: handleSubmit,
    isLoading: loading || isSimulating,
    disabled: isSimulating || hasSimulationErrors,
    "data-test-subj": "streamsAppSchemaChangesReviewModalSubmitButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 9
    }
  }, isSimulating ? _i18n.i18n.translate('xpack.streams.schemaEditor.confirmChangesModal.verifyingChangesText', {
    defaultMessage: 'Verifying changes'
  }) : confirmChangesTitle)));
}
function getChanges(fields, storedFields) {
  const addedFields = fields.filter(field => (field.status === 'mapped' || field.status === 'unmapped') && !storedFields.some(stored => stored.name === field.name));
  const changedFields = fields.filter(field => {
    const stored = storedFields.find(storedField => field.status !== 'inherited' && storedField.name === field.name);
    return stored && !(0, _lodash.isEqual)(stored, field);
  });
  return [...addedFields, ...changedFields];
}