"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaEditor = SchemaEditor;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _use_controls = require("./hooks/use_controls");
var _use_kibana = require("../../../hooks/use_kibana");
var _schema_editor_context = require("./schema_editor_context");
var _schema_editor_controls = require("./schema_editor_controls");
var _schema_editor_table = require("./schema_editor_table");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SchemaEditor({
  defaultColumns = _constants.DEFAULT_TABLE_COLUMN_NAMES,
  fields,
  isLoading,
  onFieldUpdate,
  onAddField,
  onRefreshData,
  onFieldSelection,
  fieldSelection,
  stream,
  withControls = false,
  withFieldSimulation = false,
  withTableActions = false,
  withToolbar = true
}) {
  const [controls, updateControls] = (0, _use_controls.useControls)();
  const [isLoadingRecommendations, setIsLoadingRecommendations] = _react.default.useState(false);
  const {
    core: {
      notifications
    },
    dependencies: {
      start: {
        fieldsMetadata
      }
    }
  } = (0, _use_kibana.useKibana)();
  const getRecommendations = _react.default.useCallback(async selection => {
    setIsLoadingRecommendations(true);
    const client = await fieldsMetadata.getClient();
    const ecsToOriginalField = selection.reduce((acc, name) => {
      acc[(0, _streamsSchema.getRegularEcsField)(name)] = name;
      return acc;
    }, {});
    try {
      const response = await client.find({
        attributes: ['type'],
        fieldNames: Object.keys(ecsToOriginalField)
      });
      Object.entries(response.fields).forEach(([key, value]) => {
        var _value$type;
        const originalField = fields.find(({
          name
        }) => name === ecsToOriginalField[key]);
        const type = (_value$type = value.type) !== null && _value$type !== void 0 ? _value$type : originalField.type;
        if (type && !_constants.FIELD_TYPE_MAP[type]) {
          return;
        }
        onFieldUpdate({
          ...originalField,
          type,
          status: type ? 'mapped' : 'unmapped'
        });
      });
      onFieldSelection(selection, false);
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.streams.schemaEditor.fetchRecommendationsError', {
          defaultMessage: 'Error fetching field type recommendations'
        })
      });
    } finally {
      setIsLoadingRecommendations(false);
    }
  }, [fields, fieldsMetadata, notifications.toasts, onFieldSelection, onFieldUpdate]);
  const toolbarVisibility = _react.default.useMemo(() => {
    if (!withToolbar) {
      return false;
    }
    if (fieldSelection.length === 0) {
      return true;
    }
    return {
      additionalControls: {
        left: {
          append: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            alignItems: "center",
            gutterSize: "xs",
            style: {
              marginLeft: '10px'
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 108,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            style: {
              marginRight: '10px'
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 109,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            color: "subdued",
            size: "xs",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 110,
              columnNumber: 17
            }
          }, _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableFieldsSelectedCount', {
            defaultMessage: '{count} selected:',
            values: {
              count: fieldSelection.length
            }
          }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 120,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
            flush: "left",
            size: "xs",
            isLoading: isLoadingRecommendations,
            onClick: () => {
              getRecommendations(fieldSelection);
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 121,
              columnNumber: 17
            }
          }, _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableActions.guessType', {
            defaultMessage: 'Suggest type'
          }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 137,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
            flush: "left",
            size: "xs",
            onClick: () => {
              fieldSelection.forEach(fieldName => {
                const field = fields.find(({
                  name
                }) => name === fieldName);
                onFieldUpdate((0, _lodash.omit)({
                  ...field,
                  status: 'unmapped'
                }, 'type'));
                onFieldSelection(fieldSelection, false);
              });
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 138,
              columnNumber: 17
            }
          }, _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableActions.removeType', {
            defaultMessage: 'Remove type (unmap)'
          }))))
        }
      }
    };
  }, [fields, getRecommendations, onFieldSelection, withToolbar, fieldSelection, onFieldUpdate, isLoadingRecommendations]);
  return /*#__PURE__*/_react.default.createElement(_schema_editor_context.SchemaEditorContextProvider, {
    fields: fields,
    onFieldSelection: onFieldSelection,
    fieldSelection: fieldSelection,
    isLoading: isLoading,
    onFieldUpdate: onFieldUpdate,
    stream: stream,
    withControls: withControls,
    withFieldSimulation: withFieldSimulation,
    withTableActions: withTableActions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    className: (0, _css.css)`
          min-height: 0;

          & .euiDataGrid__focusWrap {
            min-height: 0;
          }
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "fixed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  })) : null, withControls && /*#__PURE__*/_react.default.createElement(_schema_editor_controls.Controls, {
    controls: controls,
    onAddField: onAddField,
    onChange: updateControls,
    onRefreshData: onRefreshData,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_schema_editor_table.FieldsTable, {
    isLoading: isLoading !== null && isLoading !== void 0 ? isLoading : false,
    controls: controls,
    withToolbar: toolbarVisibility,
    defaultColumns: defaultColumns,
    fields: fields,
    stream: stream,
    withTableActions: withTableActions,
    selectedFields: fieldSelection,
    onFieldSelection: onFieldSelection,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  })));
}