"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatusBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/field_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FieldStatusBadge = ({
  status,
  uncommitted,
  streamType
}) => {
  // Determine the display status - for classic streams, show "dynamic" instead of "unmapped"
  const displayStatus = status === 'unmapped' && streamType === 'classic' ? 'dynamic' : status;

  // Combine tooltip messages when uncommitted
  const tooltipContent = uncommitted ? `${_constants.FIELD_STATUS_MAP[displayStatus].tooltip} ${_constants.FIELD_STATUS_MAP.pending.tooltip}` : _constants.FIELD_STATUS_MAP[displayStatus].tooltip;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: _constants.FIELD_STATUS_MAP[displayStatus].color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "center",
    wrap: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, uncommitted && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "clockCounter",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, _constants.FIELD_STATUS_MAP[displayStatus].label))));
};
exports.FieldStatusBadge = FieldStatusBadge;