"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldResultBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/field_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FIELD_RESULT_MAP = {
  created: {
    color: 'success',
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorCreatedResultLabel', {
      defaultMessage: 'Created'
    }),
    tooltip: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorCreatedResultTooltip', {
      defaultMessage: 'The simulated processing steps newly create this field.'
    })
  },
  modified: {
    color: 'warning',
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorModifiedResultLabel', {
      defaultMessage: 'Modified'
    }),
    tooltip: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorModifiedResultTooltip', {
      defaultMessage: 'The simulated processing steps modify the values of this field.'
    })
  }
};
const FieldResultBadge = ({
  result
}) => {
  if (!result) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: FIELD_RESULT_MAP[result].tooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: FIELD_RESULT_MAP[result].color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, FIELD_RESULT_MAP[result].label));
};
exports.FieldResultBadge = FieldResultBadge;