"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TABLE_COLUMNS = exports.SUPPORTED_TABLE_COLUMN_NAMES = exports.FIELD_TYPE_MAP = exports.FIELD_STATUS_MAP = exports.EMPTY_CONTENT = exports.DEFAULT_TABLE_COLUMN_NAMES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_CONTENT = exports.EMPTY_CONTENT = '-----';
const FIELD_TYPE_MAP = exports.FIELD_TYPE_MAP = {
  boolean: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableBooleanType', {
      defaultMessage: 'Boolean'
    }),
    readonly: false
  },
  date: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableDateType', {
      defaultMessage: 'Date'
    }),
    readonly: false
  },
  keyword: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableKeywordType', {
      defaultMessage: 'Keyword'
    }),
    readonly: false
  },
  match_only_text: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableTextType', {
      defaultMessage: 'Text (match_only_text)'
    }),
    readonly: false
  },
  long: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableNumberType', {
      defaultMessage: 'Number (long)'
    }),
    readonly: false
  },
  double: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableNumberType', {
      defaultMessage: 'Number (double)'
    }),
    readonly: false
  },
  ip: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableIpType', {
      defaultMessage: 'IP'
    }),
    readonly: false
  },
  system: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableSystemType', {
      defaultMessage: 'System managed'
    }),
    readonly: true
  }
};
const FIELD_STATUS_MAP = exports.FIELD_STATUS_MAP = {
  inherited: {
    color: 'hollow',
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorInheritedStatusLabel', {
      defaultMessage: 'Inherited'
    }),
    tooltip: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorInheritedStatusTooltip', {
      defaultMessage: 'The mapping for this field is inherited from the parent stream.'
    })
  },
  mapped: {
    color: 'success',
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorMappedStatusLabel', {
      defaultMessage: 'Mapped'
    }),
    tooltip: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorMappedStatusTooltip', {
      defaultMessage: 'This field is mapped as part of this stream.'
    })
  },
  unmapped: {
    color: 'default',
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorUnmappedStatusLabel', {
      defaultMessage: 'Unmapped'
    }),
    tooltip: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorUnmappedStatusTooltip', {
      defaultMessage: 'The mapping for this field is not managed by this stream or a parent.'
    })
  },
  dynamic: {
    color: 'default',
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorDynamicStatusLabel', {
      defaultMessage: 'Dynamic'
    }),
    tooltip: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorDynamicStatusTooltip', {
      defaultMessage: 'The mapping for this field is controlled by the underlying index template.'
    })
  },
  pending: {
    color: 'warning',
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorPendingStatusLabel', {
      defaultMessage: 'Pending'
    }),
    tooltip: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorPendingStatusTooltip', {
      defaultMessage: 'This field has uncommitted changes.'
    })
  }
};
const TABLE_COLUMNS = exports.TABLE_COLUMNS = {
  name: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTablenameHeader', {
      defaultMessage: 'Field'
    })
  },
  type: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTabletypeHeader', {
      defaultMessage: 'Type'
    })
  },
  format: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableformatHeader', {
      defaultMessage: 'Format'
    })
  },
  parent: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableFieldParentHeader', {
      defaultMessage: 'Field Parent (Stream)'
    })
  },
  status: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTablestatusHeader', {
      defaultMessage: 'Mapping status'
    })
  },
  source: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTablesourceHeader', {
      defaultMessage: 'Source'
    })
  },
  result: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableresultHeader', {
      defaultMessage: 'Simulation result'
    })
  }
};
const DEFAULT_TABLE_COLUMN_NAMES = exports.DEFAULT_TABLE_COLUMN_NAMES = ['name', 'type', 'format', 'parent', 'status'];
const SUPPORTED_TABLE_COLUMN_NAMES = exports.SUPPORTED_TABLE_COLUMN_NAMES = Object.keys(TABLE_COLUMNS);