"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsAppLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _common = require("@kbn/kibana-utils-plugin/common");
var _uuid = require("uuid");
var _common2 = require("../url_schema/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StreamsAppLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _deeplinksObservability.STREAMS_APP_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      let path = '/';
      if (params.name) {
        // Concat stream name
        path = `/${params.name}`;

        // Concat management tab
        if (params.managementTab) {
          path = `/${params.name}/management/${params.managementTab}`;

          // Concat page state
          if (isEnrichmentPageState(params.pageState)) {
            const parsedDataSources = params.pageState.dataSources.map(dataSource => {
              // For custom samples data source, we need to persist the documents in the browser local storage to retrieve them later.
              if (dataSource.type === 'custom-samples') {
                return parseAndPersistCustomSamplesDataSource(dataSource, params.name);
              }
              return dataSource;
            });
            path = (0, _common.setStateToKbnUrl)(_common2.ENRICHMENT_URL_STATE_KEY, {
              ...params.pageState,
              dataSources: parsedDataSources
            }, {
              useHash: false,
              storeInHashQuery: false
            }, path);
          }
        }
      }
      return {
        app: 'streams',
        path,
        state: {}
      };
    });
  }
}
exports.StreamsAppLocatorDefinition = StreamsAppLocatorDefinition;
const parseAndPersistCustomSamplesDataSource = (dataSource, streamName) => {
  var _dataSource$storageKe;
  const key = (_dataSource$storageKe = dataSource.storageKey) !== null && _dataSource$storageKe !== void 0 ? _dataSource$storageKe : `${_common2.CUSTOM_SAMPLES_DATA_SOURCE_STORAGE_KEY_PREFIX}${streamName}__${(0, _uuid.v4)()}`;
  sessionStorage.setItem(key, JSON.stringify(dataSource));
  return {
    name: dataSource.name,
    enabled: dataSource.enabled,
    type: dataSource.type,
    documents: [],
    storageKey: key
  };
};
const isEnrichmentPageState = pageState => {
  return typeof pageState === 'object' && pageState !== null && 'v' in pageState;
};