module.exports = "{\"openapi\":\"3.0.0\",\"info\":{\"title\":\"Condition API Specification\",\"version\":\"1.0.0\",\"description\":\"OpenAPI specification derived from a TypeScript file defining a condition-based filtering language.\"},\"components\":{\"schemas\":{\"StringOrNumberOrBoolean\":{\"description\":\"A value that can be a string, a number, or a boolean.\",\"oneOf\":[{\"type\":\"string\"},{\"type\":\"number\"},{\"type\":\"boolean\"}]},\"RangeCondition\":{\"type\":\"object\",\"description\":\"Defines a numeric or date range.\",\"properties\":{\"gt\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"gte\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"lt\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"lte\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"}},\"additionalProperties\":false},\"ShorthandBinaryFilterCondition\":{\"type\":\"object\",\"description\":\"A filter condition that compares a field to a value using a binary operator. It must contain 'field' and at least one operator.\",\"properties\":{\"field\":{\"type\":\"string\"},\"eq\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"neq\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"lt\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"lte\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"gt\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"gte\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"contains\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"startsWith\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"endsWith\":{\"$ref\":\"#/components/schemas/StringOrNumberOrBoolean\"},\"range\":{\"$ref\":\"#/components/schemas/RangeCondition\"}},\"required\":[\"field\"],\"anyOf\":[{\"required\":[\"eq\"]},{\"required\":[\"neq\"]},{\"required\":[\"lt\"]},{\"required\":[\"lte\"]},{\"required\":[\"gt\"]},{\"required\":[\"gte\"]},{\"required\":[\"contains\"]},{\"required\":[\"startsWith\"]},{\"required\":[\"endsWith\"]},{\"required\":[\"range\"]}]},\"ShorthandUnaryFilterCondition\":{\"type\":\"object\",\"description\":\"A filter condition that checks for the existence of a field.\",\"properties\":{\"field\":{\"type\":\"string\"},\"exists\":{\"type\":\"boolean\"}},\"required\":[\"field\",\"exists\"]},\"AndCondition\":{\"type\":\"object\",\"description\":\"A condition that is true if all of its sub-conditions are true.\",\"properties\":{\"and\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/components/schemas/Condition\"}}},\"required\":[\"and\"]},\"OrCondition\":{\"type\":\"object\",\"description\":\"A condition that is true if any of its sub-conditions are true.\",\"properties\":{\"or\":{\"type\":\"array\",\"items\":{\"$ref\":\"#/components/schemas/Condition\"}}},\"required\":[\"or\"]},\"NotCondition\":{\"type\":\"object\",\"description\":\"A condition that is true if its sub-condition is false.\",\"properties\":{\"not\":{\"$ref\":\"#/components/schemas/Condition\"}},\"required\":[\"not\"]},\"AlwaysCondition\":{\"type\":\"object\",\"description\":\"A condition that is always true.\",\"properties\":{\"always\":{\"type\":\"object\",\"description\":\"An empty object.\",\"additionalProperties\":false}},\"required\":[\"always\"]},\"NeverCondition\":{\"type\":\"object\",\"description\":\"A condition that is always false.\",\"properties\":{\"never\":{\"type\":\"object\",\"description\":\"An empty object.\",\"additionalProperties\":false}},\"required\":[\"never\"]},\"Condition\":{\"description\":\"Represents a single condition or a boolean combination of other conditions.\",\"oneOf\":[{\"$ref\":\"#/components/schemas/ShorthandBinaryFilterCondition\"},{\"$ref\":\"#/components/schemas/ShorthandUnaryFilterCondition\"},{\"$ref\":\"#/components/schemas/AndCondition\"},{\"$ref\":\"#/components/schemas/OrCondition\"},{\"$ref\":\"#/components/schemas/NotCondition\"},{\"$ref\":\"#/components/schemas/NeverCondition\"},{\"$ref\":\"#/components/schemas/AlwaysCondition\"}]}}}}\n";
