"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IdentifySystemsPrompt = void 0;
var _inferenceCommon = require("@kbn/inference-common");
var _zod = require("@kbn/zod");
var _lodash = require("lodash");
var _system_prompt = _interopRequireDefault(require("./system_prompt.text"));
var _user_prompt = _interopRequireDefault(require("./user_prompt.text"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const systemsSchemaBase = {
  type: 'object',
  properties: {
    systems: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          name: {
            type: 'string'
          },
          filter: {
            type: 'object',
            properties: {}
          }
        }
      }
    }
  },
  required: ['systems']
};
const systemsSchema = (0, _lodash.merge)({}, systemsSchemaBase, {
  properties: {
    systems: {
      items: {
        required: ['name', 'filter']
      }
    }
  }
});
const finalSystemsSchema = (0, _lodash.merge)({}, systemsSchema);
const IdentifySystemsPrompt = exports.IdentifySystemsPrompt = (0, _inferenceCommon.createPrompt)({
  name: 'identify_systems',
  input: _zod.z.object({
    stream: _zod.z.object({
      name: _zod.z.string(),
      description: _zod.z.string()
    }),
    dataset_analysis: _zod.z.string(),
    initial_clustering: _zod.z.string(),
    condition_schema: _zod.z.string()
  })
}).version({
  system: {
    mustache: {
      template: _system_prompt.default
    }
  },
  template: {
    mustache: {
      template: _user_prompt.default
    }
  },
  tools: {
    validate_systems: {
      description: `Validate systems before finalizing`,
      schema: systemsSchema
    },
    finalize_systems: {
      description: 'Finalize system identification',
      schema: finalSystemsSchema
    }
  }
}).get();