"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertDropDocumentProcessorToESQL = void 0;
var _esqlAst = require("@kbn/esql-ast");
var _condition_to_esql = require("../condition_to_esql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertDropDocumentProcessorToESQL = processor => {
  const {
    where
  } = processor;
  const whereCondition = (0, _condition_to_esql.conditionToESQLAst)(where);
  return [_esqlAst.Builder.command({
    name: 'WHERE',
    args: [_esqlAst.Builder.expression.func.unary('NOT', whereCondition)]
  })];
};
exports.convertDropDocumentProcessorToESQL = convertDropDocumentProcessorToESQL;