"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertConditionToESQL = convertConditionToESQL;
exports.convertStreamlangDSLToESQLCommands = convertStreamlangDSLToESQLCommands;
var _esqlAst = require("@kbn/esql-ast");
var _condition_to_esql = require("./condition_to_esql");
var _rename = require("./processors/rename");
var _set = require("./processors/set");
var _append = require("./processors/append");
var _date = require("./processors/date");
var _dissect = require("./processors/dissect");
var _grok = require("./processors/grok");
var _convert = require("./processors/convert");
var _remove_by_prefix = require("./processors/remove_by_prefix");
var _remove = require("./processors/remove");
var _drop_document = require("./processors/drop_document");
var _replace = require("./processors/replace");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertProcessorToESQL(processor) {
  switch (processor.action) {
    case 'rename':
      return (0, _rename.convertRenameProcessorToESQL)(processor);
    case 'set':
      return (0, _set.convertSetProcessorToESQL)(processor);
    case 'append':
      return (0, _append.convertAppendProcessorToESQL)(processor);
    case 'convert':
      return (0, _convert.convertConvertProcessorToESQL)(processor);
    case 'date':
      return (0, _date.convertDateProcessorToESQL)(processor);
    case 'dissect':
      return (0, _dissect.convertDissectProcessorToESQL)(processor);
    case 'grok':
      return (0, _grok.convertGrokProcessorToESQL)(processor);
    case 'remove_by_prefix':
      return (0, _remove_by_prefix.convertRemoveByPrefixProcessorToESQL)(processor);
    case 'remove':
      return (0, _remove.convertRemoveProcessorToESQL)(processor);
    case 'drop_document':
      return (0, _drop_document.convertDropDocumentProcessorToESQL)(processor);
    case 'replace':
      return (0, _replace.convertReplaceProcessorToESQL)(processor);
    case 'manual_ingest_pipeline':
      return [_esqlAst.Builder.command({
        name: 'eval',
        args: [_esqlAst.Builder.expression.literal.string('WARNING: Manual ingest pipeline not supported in ES|QL')]
      })];
    default:
      return null;
  }
}
function convertStreamlangDSLToESQLCommands(actionSteps, transpilationOptions) {
  const esqlAstCommands = actionSteps.map(processor => convertProcessorToESQL(processor)).filter(cmds => cmds !== null).flat();
  const query = _esqlAst.Builder.expression.query(esqlAstCommands);
  return _esqlAst.BasicPrettyPrinter.multiline(query, {
    pipeTab: transpilationOptions.pipeTab
  });
}

/**
 * Converts a condition to ES|QL string format using the existing AST approach
 * @example: { field: "age", range: { gte: 18, lt: 65 } } -> "age >= 18 AND age < 65"
 */
function convertConditionToESQL(condition) {
  const ast = (0, _condition_to_esql.conditionToESQLAst)(condition);
  return _esqlAst.BasicPrettyPrinter.print(ast);
}