"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackConnectorsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _inference_connectors_usage_collector = require("./usage/inference/inference_connectors_usage_collector");
var _connector_types = require("./connector_types");
var _routes = require("./routes");
var _experimental_features = require("../common/experimental_features");
var _connector_types_from_spec = require("./connector_types_from_spec");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StackConnectorsPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.logger = context.logger.get();
    this.config = context.config.get();
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || []);
  }
  setup(core, plugins) {
    const router = core.http.createRouter();
    const {
      actions
    } = plugins;
    const awsSesConfig = actions.getActionsConfigurationUtilities().getAwsSesConfig();
    (0, _routes.getWellKnownEmailServiceRoute)(router, awsSesConfig);
    (0, _routes.validSlackApiChannelsRoute)(router, actions.getActionsConfigurationUtilities(), this.logger);
    (0, _routes.getWebhookSecretHeadersKeyRoute)(router, core.getStartServices);
    (0, _connector_types.registerConnectorTypes)({
      actions,
      publicBaseUrl: core.http.basePath.publicBaseUrl,
      experimentalFeatures: this.experimentalFeatures
    });
    if (this.experimentalFeatures.connectorsFromSpecs) {
      (0, _connector_types_from_spec.registerConnectorTypesFromSpecs)({
        actions
      });
    }
    if (plugins.usageCollection) {
      (0, _inference_connectors_usage_collector.registerInferenceConnectorsUsageCollector)(plugins.usageCollection, core);
    }
  }
  start() {}
  stop() {}
}
exports.StackConnectorsPlugin = StackConnectorsPlugin;