"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerConnectorTypesFromSpecs = registerConnectorTypesFromSpecs;
var _connectorSpecs = require("@kbn/connector-specs");
var _lib = require("@kbn/actions-plugin/server/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerConnectorTypesFromSpecs({
  actions
}) {
  // Register connector specs
  for (const spec of Object.values(_connectorSpecs.connectorsSpecs)) {
    actions.registerType((0, _lib.createConnectorTypeFromSpec)(spec, actions));
  }
}