"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _xsoar = require("@kbn/connector-schemas/xsoar");
var _xsoar2 = require("./xsoar");
var _render = require("./render");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getConnectorType() {
  return {
    id: _xsoar.CONNECTOR_ID,
    minimumLicenseRequired: 'platinum',
    name: _xsoar.CONNECTOR_NAME,
    getService: params => new _xsoar2.XSOARConnector(params),
    supportedFeatureIds: [_common.SecurityConnectorFeatureId, _common.WorkflowsConnectorFeatureId],
    schema: {
      config: _xsoar.ConfigSchema,
      secrets: _xsoar.SecretsSchema
    },
    renderParameterTemplates: _render.renderParameterTemplates,
    validators: [{
      type: _types.ValidatorType.CONFIG,
      validator: (0, _server.urlAllowListValidator)('url')
    }]
  };
}