"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTinesConnectorType = void 0;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _tines = require("@kbn/connector-schemas/tines");
var _tines2 = require("./tines");
var _render = require("./render");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTinesConnectorType = () => ({
  id: _tines.CONNECTOR_ID,
  name: _tines.CONNECTOR_NAME,
  getService: params => new _tines2.TinesConnector(params),
  schema: {
    config: _tines.TinesConfigSchema,
    secrets: _tines.TinesSecretsSchema
  },
  validators: [{
    type: _types.ValidatorType.CONFIG,
    validator: (0, _server.urlAllowListValidator)('url')
  }],
  supportedFeatureIds: [_common.SecurityConnectorFeatureId, _common.WorkflowsConnectorFeatureId],
  minimumLicenseRequired: 'gold',
  renderParameterTemplates: _render.renderParameterTemplates
});
exports.getTinesConnectorType = getTinesConnectorType;