"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TinesWebhooksApiResponseSchema = exports.TinesWebhookApiResponseSchema = exports.TinesStoriesApiResponseSchema = exports.TinesRunApiResponseSchema = exports.TinesBaseApiResponseSchema = void 0;
var _zod = require("@kbn/zod");
var _tines = require("@kbn/connector-schemas/tines");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Tines response base schema
const TinesBaseApiResponseSchema = exports.TinesBaseApiResponseSchema = _zod.z.object({
  meta: _zod.z.object({
    pages: _zod.z.coerce.number()
  })
});

// Stories action schema
const TinesStoriesApiResponseSchema = exports.TinesStoriesApiResponseSchema = TinesBaseApiResponseSchema.extend({
  stories: _zod.z.array(_tines.TinesStoryObjectSchema.extend({}).strip())
});

// Single Webhook action schema
const TinesWebhookApiResponseSchema = exports.TinesWebhookApiResponseSchema = _zod.z.object({
  id: _zod.z.coerce.number(),
  name: _zod.z.string(),
  type: _zod.z.string(),
  story_id: _zod.z.coerce.number(),
  options: _zod.z.object({
    path: _zod.z.string().optional(),
    secret: _zod.z.string().optional()
  })
});

// Webhooks action schema
const TinesWebhooksApiResponseSchema = exports.TinesWebhooksApiResponseSchema = TinesBaseApiResponseSchema.extend({
  agents: _zod.z.array(TinesWebhookApiResponseSchema)
});
const TinesRunApiResponseSchema = exports.TinesRunApiResponseSchema = _zod.z.object({});