"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TheHiveConnector = exports.API_VERSION = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/actions-plugin/server");
var _thehive = require("@kbn/connector-schemas/thehive");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_VERSION = exports.API_VERSION = 'v1';
class TheHiveConnector extends _server.CaseConnector {
  constructor(params, pushToServiceParamsExtendedSchema) {
    var _this$url;
    super(params, pushToServiceParamsExtendedSchema);
    (0, _defineProperty2.default)(this, "url", void 0);
    (0, _defineProperty2.default)(this, "apiKey", void 0);
    (0, _defineProperty2.default)(this, "organisation", void 0);
    (0, _defineProperty2.default)(this, "urlWithoutTrailingSlash", void 0);
    this.registerSubAction({
      name: _thehive.SUB_ACTION.CREATE_ALERT,
      method: 'createAlert',
      schema: _thehive.ExecutorSubActionCreateAlertParamsSchema
    });
    this.url = this.config.url;
    this.organisation = this.config.organisation;
    this.apiKey = this.secrets.apiKey;
    this.urlWithoutTrailingSlash = (_this$url = this.url) !== null && _this$url !== void 0 && _this$url.endsWith('/') ? this.url.slice(0, -1) : this.url;
  }
  getAuthHeaders() {
    return {
      Authorization: `Bearer ${this.apiKey}`,
      'X-Organisation': this.organisation
    };
  }
  getResponseErrorMessage(error) {
    var _error$response, _error$response2, _error$response2$data, _error$response3, _error$response3$data;
    if (!((_error$response = error.response) !== null && _error$response !== void 0 && _error$response.status)) {
      return 'Unknown API Error';
    }
    return `API Error: ${(_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : (_error$response2$data = _error$response2.data) === null || _error$response2$data === void 0 ? void 0 : _error$response2$data.type} - ${(_error$response3 = error.response) === null || _error$response3 === void 0 ? void 0 : (_error$response3$data = _error$response3.data) === null || _error$response3$data === void 0 ? void 0 : _error$response3$data.message}`;
  }
  async createIncident(incident, connectorUsageCollector) {
    const res = await this.request({
      method: 'post',
      url: `${this.url}/api/${API_VERSION}/case`,
      data: incident,
      headers: this.getAuthHeaders(),
      responseSchema: _thehive.TheHiveIncidentResponseSchema
    }, connectorUsageCollector);
    return {
      id: res.data._id,
      title: res.data.title,
      url: `${this.urlWithoutTrailingSlash}/cases/${res.data._id}/details`,
      pushedDate: new Date(res.data._createdAt).toISOString()
    };
  }
  async addComment({
    incidentId,
    comment
  }, connectorUsageCollector) {
    await this.request({
      method: 'post',
      url: `${this.url}/api/${API_VERSION}/case/${incidentId}/comment`,
      data: {
        message: comment
      },
      headers: this.getAuthHeaders(),
      responseSchema: _thehive.TheHiveAddCommentResponseSchema
    }, connectorUsageCollector);
  }
  async updateIncident({
    incidentId,
    incident
  }, connectorUsageCollector) {
    await this.request({
      method: 'patch',
      url: `${this.url}/api/${API_VERSION}/case/${incidentId}`,
      data: incident,
      headers: this.getAuthHeaders(),
      responseSchema: _thehive.TheHiveUpdateIncidentResponseSchema
    }, connectorUsageCollector);
    return {
      id: incidentId,
      title: incident.title,
      url: `${this.urlWithoutTrailingSlash}/cases/${incidentId}/details`,
      pushedDate: new Date().toISOString()
    };
  }
  async getIncident({
    id
  }, connectorUsageCollector) {
    const res = await this.request({
      url: `${this.url}/api/${API_VERSION}/case/${id}`,
      headers: this.getAuthHeaders(),
      responseSchema: _thehive.TheHiveIncidentResponseSchema
    }, connectorUsageCollector);
    return res.data;
  }
  formatAlertBody(alert) {
    try {
      const {
        body,
        isRuleSeverity,
        ...restOfAlert
      } = alert;
      const bodyJson = JSON.parse(body || '{}');
      const mergedAlertBody = {
        ...bodyJson,
        ...restOfAlert
      };
      return mergedAlertBody;
    } catch (err) {
      throw new Error(_i18n.i18n.translate('xpack.stackConnectors.thehive.alertBodyParsingError', {
        defaultMessage: 'Error parsing alert body for thehive: {err}',
        values: {
          err: err.toString()
        }
      }));
    }
  }
  async createAlert(alert, connectorUsageCollector) {
    const mergedAlertBody = this.formatAlertBody(alert);
    await this.request({
      method: 'post',
      url: `${this.url}/api/${API_VERSION}/alert`,
      data: mergedAlertBody,
      headers: this.getAuthHeaders(),
      responseSchema: _thehive.TheHiveCreateAlertResponseSchema
    }, connectorUsageCollector);
  }
}
exports.TheHiveConnector = TheHiveConnector;