"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _thehive = require("@kbn/connector-schemas/thehive");
var _thehive2 = require("./thehive");
var _render = require("./render");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getConnectorType() {
  return {
    id: _thehive.CONNECTOR_ID,
    minimumLicenseRequired: 'platinum',
    name: _thehive.CONNECTOR_NAME,
    getService: params => new _thehive2.TheHiveConnector(params, _thehive.PushToServiceIncidentSchema),
    supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.SecurityConnectorFeatureId, _common.UptimeConnectorFeatureId, _common.CasesConnectorFeatureId, _common.WorkflowsConnectorFeatureId],
    schema: {
      config: _thehive.TheHiveConfigSchema,
      secrets: _thehive.TheHiveSecretsSchema
    },
    renderParameterTemplates: _render.renderParameterTemplates,
    validators: [{
      type: _types.ValidatorType.CONFIG,
      validator: (0, _server.urlAllowListValidator)('url')
    }]
  };
}