"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _common = require("@kbn/actions-plugin/common");
var _swimlane = require("@kbn/connector-schemas/swimlane");
var _validators = require("./validators");
var _service = require("./service");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const supportedSubActions = ['pushToService'];

// connector type definition
function getConnectorType() {
  return {
    id: _swimlane.CONNECTOR_ID,
    minimumLicenseRequired: 'gold',
    name: _swimlane.CONNECTOR_NAME,
    supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.CasesConnectorFeatureId, _common.SecurityConnectorFeatureId, _common.WorkflowsConnectorFeatureId],
    validate: {
      config: {
        schema: _swimlane.SwimlaneServiceConfigurationSchema,
        customValidator: _validators.validate.config
      },
      secrets: {
        schema: _swimlane.SwimlaneSecretsConfigurationSchema,
        customValidator: _validators.validate.secrets
      },
      params: {
        schema: _swimlane.ExecutorParamsSchema
      }
    },
    executor
  };
}
async function executor(execOptions) {
  var _data;
  const {
    actionId,
    config,
    params,
    secrets,
    configurationUtilities,
    logger,
    connectorUsageCollector
  } = execOptions;
  const {
    subAction,
    subActionParams
  } = params;
  let data = null;
  const externalService = (0, _service.createExternalService)({
    config,
    secrets
  }, logger, configurationUtilities, connectorUsageCollector);
  if (!_api.api[subAction]) {
    const errorMessage = `[Action][ExternalService] -> [Swimlane] Unsupported subAction type ${subAction}.`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }
  if (!supportedSubActions.includes(subAction)) {
    const errorMessage = `[Action][ExternalService] -> [Swimlane] subAction ${subAction} not implemented.`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }
  if (subAction === 'pushToService') {
    const pushToServiceParams = subActionParams;
    data = await _api.api.pushToService({
      externalService,
      params: pushToServiceParams,
      logger
    });
    logger.debug(`response push to service for incident id: ${data.id}`);
  }
  return {
    status: 'ok',
    data: (_data = data) !== null && _data !== void 0 ? _data : {},
    actionId
  };
}