"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceNowSIRConnectorType = getServiceNowSIRConnectorType;
Object.defineProperty(exports, "serviceNowSIRTable", {
  enumerable: true,
  get: function () {
    return _config.serviceNowSIRTable;
  }
});
var _lodash = require("lodash");
var _common = require("@kbn/actions-plugin/common");
var _servicenow = require("@kbn/connector-schemas/servicenow");
var _servicenow_sir = require("@kbn/connector-schemas/servicenow_sir");
var _validators = require("../lib/servicenow/validators");
var _config = require("../lib/servicenow/config");
var _service = require("./service");
var _api = require("./api");
var _utils = require("../lib/servicenow/utils");
var _create_service_wrapper = require("../lib/servicenow/create_service_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// connector type definition
function getServiceNowSIRConnectorType() {
  return {
    id: _servicenow_sir.CONNECTOR_ID,
    minimumLicenseRequired: 'platinum',
    name: _servicenow_sir.CONNECTOR_NAME,
    supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.CasesConnectorFeatureId, _common.SecurityConnectorFeatureId, _common.WorkflowsConnectorFeatureId],
    validate: {
      config: {
        schema: _servicenow.ExternalIncidentServiceConfigurationSchema,
        customValidator: _validators.validate.config
      },
      secrets: {
        schema: _servicenow.ExternalIncidentServiceSecretConfigurationSchema,
        customValidator: _validators.validate.secrets
      },
      connector: _validators.validate.connector,
      params: {
        schema: _servicenow_sir.ExecutorParamsSchemaSIR
      }
    },
    executor: (0, _lodash.curry)(executor)({
      actionTypeId: _servicenow_sir.CONNECTOR_ID,
      createService: _service.createExternalService,
      api: _api.api
    })
  };
}

// action executor
const supportedSubActions = ['getFields', 'pushToService', 'getChoices', 'getIncident'];
async function executor({
  actionTypeId,
  createService,
  api
}, execOptions) {
  var _data;
  const {
    actionId,
    config,
    params,
    secrets,
    services,
    configurationUtilities,
    logger,
    connectorUsageCollector
  } = execOptions;
  const {
    subAction,
    subActionParams
  } = params;
  const connectorTokenClient = services.connectorTokenClient;
  const externalServiceConfig = _config.snExternalServiceConfig[actionTypeId];
  let data = null;
  const externalService = (0, _create_service_wrapper.createServiceWrapper)({
    connectorId: actionId,
    credentials: {
      config,
      secrets
    },
    logger,
    configurationUtilities,
    serviceConfig: externalServiceConfig,
    connectorTokenClient,
    createServiceFn: createService,
    connectorUsageCollector
  });
  const apiAsRecord = api;
  (0, _utils.throwIfSubActionIsNotSupported)({
    api: apiAsRecord,
    subAction,
    supportedSubActions,
    logger
  });
  if (subAction === 'pushToService') {
    const pushToServiceParams = subActionParams;
    data = await api.pushToService({
      externalService,
      params: pushToServiceParams,
      config,
      secrets,
      logger,
      commentFieldKey: externalServiceConfig.commentFieldKey
    });
    logger.debug(`response push to service for incident id: ${data.id}`);
  }
  if (subAction === 'getFields') {
    const getFieldsParams = subActionParams;
    data = await api.getFields({
      externalService,
      params: getFieldsParams,
      logger
    });
  }
  if (subAction === 'getChoices') {
    const getChoicesParams = subActionParams;
    data = await api.getChoices({
      externalService,
      params: getChoicesParams,
      logger
    });
  }
  return {
    status: 'ok',
    data: (_data = data) !== null && _data !== void 0 ? _data : {},
    actionId
  };
}