"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceNowITOMConnectorType = getServiceNowITOMConnectorType;
var _lodash = require("lodash");
var _common = require("@kbn/actions-plugin/common");
var _servicenow = require("@kbn/connector-schemas/servicenow");
var _servicenow_itom = require("@kbn/connector-schemas/servicenow_itom");
var _validators = require("../lib/servicenow/validators");
var _config = require("../lib/servicenow/config");
var _utils = require("../lib/servicenow/utils");
var _service = require("./service");
var _api = require("./api");
var _create_service_wrapper = require("../lib/servicenow/create_service_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// connector type definition
function getServiceNowITOMConnectorType() {
  return {
    id: _servicenow_itom.CONNECTOR_ID,
    minimumLicenseRequired: 'platinum',
    name: _servicenow_itom.CONNECTOR_NAME,
    supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.SecurityConnectorFeatureId, _common.WorkflowsConnectorFeatureId],
    validate: {
      config: {
        schema: _servicenow.ExternalIncidentServiceConfigurationBaseSchema,
        customValidator: _validators.validate.config
      },
      secrets: {
        schema: _servicenow.ExternalIncidentServiceSecretConfigurationSchema,
        customValidator: _validators.validate.secrets
      },
      connector: _validators.validate.connector,
      params: {
        schema: _servicenow_itom.ExecutorParamsSchemaITOM
      }
    },
    executor: (0, _lodash.curry)(executorITOM)({
      actionTypeId: _servicenow_itom.CONNECTOR_ID,
      createService: _service.createExternalService,
      api: _api.api
    })
  };
}

// action executor
const supportedSubActionsITOM = ['addEvent', 'getChoices'];
async function executorITOM({
  actionTypeId,
  createService,
  api
}, execOptions) {
  var _data;
  const {
    actionId,
    config,
    params,
    secrets,
    configurationUtilities,
    logger,
    connectorUsageCollector
  } = execOptions;
  const {
    subAction,
    subActionParams
  } = params;
  const connectorTokenClient = execOptions.services.connectorTokenClient;
  const externalServiceConfig = _config.snExternalServiceConfig[actionTypeId];
  let data = null;
  const externalService = (0, _create_service_wrapper.createServiceWrapper)({
    connectorId: actionId,
    credentials: {
      config,
      secrets
    },
    logger,
    configurationUtilities,
    serviceConfig: externalServiceConfig,
    connectorTokenClient,
    createServiceFn: createService,
    connectorUsageCollector
  });
  const apiAsRecord = api;
  (0, _utils.throwIfSubActionIsNotSupported)({
    api: apiAsRecord,
    subAction,
    supportedSubActions: supportedSubActionsITOM,
    logger
  });
  if (subAction === 'addEvent') {
    const eventParams = subActionParams;
    await api.addEvent({
      externalService,
      params: eventParams,
      logger
    });
  }
  if (subAction === 'getChoices') {
    const getChoicesParams = subActionParams;
    data = await api.getChoices({
      externalService,
      params: getChoicesParams,
      logger
    });
  }
  return {
    status: 'ok',
    data: (_data = data) !== null && _data !== void 0 ? _data : {},
    actionId
  };
}