"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/actions-plugin/common");
var _server_log = require("@kbn/connector-schemas/server_log");
var _string_utils = require("../lib/string_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// connector type definition
function getConnectorType() {
  return {
    id: _server_log.CONNECTOR_ID,
    minimumLicenseRequired: 'basic',
    name: _server_log.CONNECTOR_NAME,
    supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.UptimeConnectorFeatureId, _common.SecurityConnectorFeatureId],
    validate: {
      config: {
        schema: _server_log.ConfigSchema
      },
      secrets: {
        schema: _server_log.SecretsSchema
      },
      params: {
        schema: _server_log.ParamsSchema
      }
    },
    executor
  };
}

// action executor

async function executor(execOptions) {
  const {
    actionId,
    params,
    logger
  } = execOptions;
  const sanitizedMessage = (0, _string_utils.withoutControlCharacters)(params.message);
  try {
    logger[params.level](`Server log: ${sanitizedMessage}`);
  } catch (err) {
    const message = _i18n.i18n.translate('xpack.stackConnectors.serverLog.errorLoggingErrorMessage', {
      defaultMessage: 'error logging message'
    });
    return {
      status: 'error',
      message,
      serviceMessage: err.message,
      actionId
    };
  }
  return {
    status: 'ok',
    actionId
  };
}