"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResilientConnectorType = void 0;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _resilient = require("@kbn/connector-schemas/resilient");
var _resilient2 = require("./resilient");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getResilientConnectorType = () => ({
  id: _resilient.CONNECTOR_ID,
  minimumLicenseRequired: 'platinum',
  name: _resilient.CONNECTOR_NAME,
  getService: params => new _resilient2.ResilientConnector(params, _resilient.PushToServiceIncidentSchema),
  schema: {
    config: _resilient.ExternalIncidentServiceConfigurationSchema,
    secrets: _resilient.ExternalIncidentServiceSecretConfigurationSchema
  },
  supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.CasesConnectorFeatureId, _common.SecurityConnectorFeatureId, _common.WorkflowsConnectorFeatureId],
  validators: [{
    type: _types.ValidatorType.CONFIG,
    validator: (0, _server.urlAllowListValidator)('apiUrl')
  }]
});
exports.getResilientConnectorType = getResilientConnectorType;