"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOpsgenieConnectorType = void 0;
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _opsgenie = require("@kbn/connector-schemas/opsgenie");
var _connector = require("./connector");
var _render_template_variables = require("./render_template_variables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOpsgenieConnectorType = () => {
  return {
    getService: params => new _connector.OpsgenieConnector(params),
    minimumLicenseRequired: 'platinum',
    name: _opsgenie.CONNECTOR_NAME,
    id: _opsgenie.CONNECTOR_ID,
    schema: {
      config: _opsgenie.ConfigSchema,
      secrets: _opsgenie.SecretsSchema
    },
    validators: [{
      type: _types.ValidatorType.CONFIG,
      validator: (0, _server.urlAllowListValidator)('apiUrl')
    }],
    supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.UptimeConnectorFeatureId, _common.SecurityConnectorFeatureId, _common.WorkflowsConnectorFeatureId],
    renderParameterTemplates: _render_template_variables.renderParameterTemplates
  };
};
exports.getOpsgenieConnectorType = getOpsgenieConnectorType;