"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMicrosoftDefenderEndpointConnectorType = void 0;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _feature = require("@kbn/actions-plugin/server/feature");
var _microsoft_defender_endpoint = require("@kbn/connector-schemas/microsoft_defender_endpoint");
var _microsoft_defender_endpoint2 = require("./microsoft_defender_endpoint");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMicrosoftDefenderEndpointConnectorType = () => ({
  id: _microsoft_defender_endpoint.CONNECTOR_ID,
  name: _microsoft_defender_endpoint.CONNECTOR_NAME,
  getService: params => new _microsoft_defender_endpoint2.MicrosoftDefenderEndpointConnector(params),
  schema: {
    config: _microsoft_defender_endpoint.MicrosoftDefenderEndpointConfigSchema,
    secrets: _microsoft_defender_endpoint.MicrosoftDefenderEndpointSecretsSchema
  },
  validators: [{
    type: _types.ValidatorType.CONFIG,
    validator: (0, _server.urlAllowListValidator)('oAuthServerUrl')
  }, {
    type: _types.ValidatorType.CONFIG,
    validator: (0, _server.urlAllowListValidator)('apiUrl')
  }],
  supportedFeatureIds: [_common.EndpointSecurityConnectorFeatureId],
  minimumLicenseRequired: 'enterprise',
  subFeature: 'endpointSecurity',
  getKibanaPrivileges: args => {
    var _args$params;
    const privileges = [_feature.ENDPOINT_SECURITY_EXECUTE_PRIVILEGE];
    if ((args === null || args === void 0 ? void 0 : args.source) === _server.ActionExecutionSourceType.HTTP_REQUEST && (args === null || args === void 0 ? void 0 : (_args$params = args.params) === null || _args$params === void 0 ? void 0 : _args$params.subAction) !== _microsoft_defender_endpoint.SUB_ACTION.TEST_CONNECTOR) {
      privileges.push(_feature.ENDPOINT_SECURITY_SUB_ACTIONS_EXECUTE_PRIVILEGE);
    }
    return privileges;
  }
});
exports.getMicrosoftDefenderEndpointConnectorType = getMicrosoftDefenderEndpointConnectorType;