"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OTHER_FIELDS_PROPERTY_ERROR = exports.OTHER_FIELDS_LENGTH_ERROR = exports.ALLOWED_HOSTS_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALLOWED_HOSTS_ERROR = message => _i18n.i18n.translate('xpack.stackConnectors.jira.configuration.apiAllowedHostsError', {
  defaultMessage: 'error configuring connector action: {message}',
  values: {
    message
  }
});
exports.ALLOWED_HOSTS_ERROR = ALLOWED_HOSTS_ERROR;
const OTHER_FIELDS_LENGTH_ERROR = length => _i18n.i18n.translate('xpack.stackConnectors.jira.schema.otherFieldsLengthError', {
  values: {
    length
  },
  defaultMessage: 'A maximum of {length} otherFields can be defined at a time.'
});
exports.OTHER_FIELDS_LENGTH_ERROR = OTHER_FIELDS_LENGTH_ERROR;
const OTHER_FIELDS_PROPERTY_ERROR = properties => _i18n.i18n.translate('xpack.stackConnectors.jira.schema.otherFieldsPropertyError', {
  values: {
    properties
  },
  defaultMessage: 'The following properties cannot be defined inside otherFields: {properties}.'
});
exports.OTHER_FIELDS_PROPERTY_ERROR = OTHER_FIELDS_PROPERTY_ERROR;