"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JiraServiceManagementConnector = void 0;
var _crypto = _interopRequireDefault(require("crypto"));
var _server = require("@kbn/actions-plugin/server");
var _lodash = require("lodash");
var _jiraServiceManagement = require("@kbn/connector-schemas/jira-service-management");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_API_BASE_PATH = 'jsm/ops/integration/v2';
class JiraServiceManagementConnector extends _server.SubActionConnector {
  constructor(params) {
    super(params);
    this.registerSubAction({
      method: this.createAlert.name,
      name: _jiraServiceManagement.SUB_ACTION.CreateAlert,
      schema: _jiraServiceManagement.CreateAlertParamsSchema
    });
    this.registerSubAction({
      method: this.closeAlert.name,
      name: _jiraServiceManagement.SUB_ACTION.CloseAlert,
      schema: _jiraServiceManagement.CloseAlertParamsSchema
    });
  }
  getResponseErrorMessage(error) {
    var _ref, _error$response$data$, _error$response, _error$response2, _error$response2$data;
    const mainMessage = (_ref = (_error$response$data$ = (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.data.message) !== null && _error$response$data$ !== void 0 ? _error$response$data$ : error.message) !== null && _ref !== void 0 ? _ref : i18n.UNKNOWN_ERROR;
    if (((_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : (_error$response2$data = _error$response2.data) === null || _error$response2$data === void 0 ? void 0 : _error$response2$data.errors) != null) {
      var _error$response3, _error$response3$data;
      const message = this.getDetailedErrorMessage((_error$response3 = error.response) === null || _error$response3 === void 0 ? void 0 : (_error$response3$data = _error$response3.data) === null || _error$response3$data === void 0 ? void 0 : _error$response3$data.errors);
      if (!(0, _lodash.isEmpty)(message)) {
        return `${mainMessage}: ${message}`;
      }
    }
    return mainMessage;
  }

  /**
   * When testing invalid requests with JiraServiceManagement the response seems to take the form:
   * {
   *   ['field that is invalid']: 'message about what the issue is'
   * }
   *
   * e.g.
   *
   * {
   *   "message": "Message can not be empty.",
   *   "username": "must be a well-formed email address"
   * }
   *
   * So we'll just stringify it.
   */
  getDetailedErrorMessage(errorField) {
    try {
      return JSON.stringify(errorField);
    } catch (error) {
      return;
    }
  }
  async createAlert(params, connectorUsageCollector) {
    const url = this.concatPathToURL(`${INTEGRATION_API_BASE_PATH}/alerts`).toString();
    const res = await this.request({
      method: 'post',
      url,
      data: {
        ...params,
        ...JiraServiceManagementConnector.createAliasObj(params.alias)
      },
      headers: this.createHeaders(),
      responseSchema: _jiraServiceManagement.Response
    }, connectorUsageCollector);
    return res.data;
  }
  static createAliasObj(alias) {
    if (!alias) {
      return {};
    }
    const newAlias = JiraServiceManagementConnector.createAlias(alias);
    return {
      alias: newAlias
    };
  }
  static createAlias(alias) {
    // JSM requires that the alias length be no more than 512 characters
    // see their docs for more details https://developer.atlassian.com/cloud/jira/service-desk-ops/rest/v2/api-group-alerts/#api-v1-alerts-post-request
    if (alias.length <= 512) {
      return alias;
    }

    // To give preference to avoiding collisions we're using sha256 over of md5 but we are compromising on speed a bit here
    const hasher = _crypto.default.createHash('sha256');
    const sha256Hash = hasher.update(alias);
    return `sha-${sha256Hash.digest('hex')}`;
  }
  createHeaders() {
    return {
      Authorization: `GenieKey ${this.secrets.apiKey}`
    };
  }
  async closeAlert(params, connectorUsageCollector) {
    const newAlias = JiraServiceManagementConnector.createAlias(params.alias);
    const fullURL = this.concatPathToURL(`${INTEGRATION_API_BASE_PATH}/alerts/${newAlias}/close`);
    fullURL.searchParams.set('identifierType', 'alias');
    const {
      alias,
      ...paramsWithoutAlias
    } = params;
    const res = await this.request({
      method: 'post',
      url: fullURL.toString(),
      data: paramsWithoutAlias,
      headers: this.createHeaders(),
      responseSchema: _jiraServiceManagement.Response
    }, connectorUsageCollector);
    return res.data;
  }
  concatPathToURL(path) {
    return new URL(path, this.config.apiUrl);
  }
}
exports.JiraServiceManagementConnector = JiraServiceManagementConnector;