"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = exports.configValidator = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _common = require("@kbn/actions-plugin/common");
var _server = require("@kbn/actions-plugin/server");
var _validators = require("@kbn/actions-plugin/server/sub_action_framework/helpers/validators");
var _gemini = require("@kbn/connector-schemas/gemini");
var _gemini2 = require("./gemini");
var _render = require("./render");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorType = () => ({
  id: _gemini.CONNECTOR_ID,
  name: _gemini.CONNECTOR_NAME,
  getService: params => new _gemini2.GeminiConnector(params),
  schema: {
    config: _gemini.ConfigSchema,
    secrets: _gemini.SecretsSchema
  },
  validators: [{
    type: _types.ValidatorType.CONFIG,
    validator: configValidator
  }],
  supportedFeatureIds: [_common.GenerativeAIForSecurityConnectorFeatureId, _common.GenerativeAIForSearchPlaygroundConnectorFeatureId, _common.GenerativeAIForObservabilityConnectorFeatureId, _common.WorkflowsConnectorFeatureId],
  minimumLicenseRequired: 'enterprise',
  renderParameterTemplates: _render.renderParameterTemplates
});
exports.getConnectorType = getConnectorType;
const configValidator = (configObject, validatorServices) => {
  try {
    (0, _validators.assertURL)(configObject.apiUrl);
    (0, _server.urlAllowListValidator)('apiUrl')(configObject, validatorServices);
    return configObject;
  } catch (err) {
    throw new Error(_i18n.i18n.translate('xpack.stackConnectors.gemini.configurationErrorApiProvider', {
      defaultMessage: 'Error configuring Google Gemini action: {err}',
      values: {
        err: err.toString()
      }
    }));
  }
};
exports.configValidator = configValidator;