"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _types = require("@kbn/actions-plugin/server/sub_action_framework/types");
var _server = require("@kbn/actions-plugin/server");
var _common = require("@kbn/actions-plugin/common");
var _d3security = require("@kbn/connector-schemas/d3security");
var _render = require("./render");
var _d3security2 = require("./d3security");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getConnectorType() {
  return {
    id: _d3security.CONNECTOR_ID,
    minimumLicenseRequired: 'gold',
    name: _d3security.CONNECTOR_NAME,
    getService: params => new _d3security2.D3SecurityConnector(params),
    supportedFeatureIds: [_common.AlertingConnectorFeatureId, _common.SecurityConnectorFeatureId, _common.WorkflowsConnectorFeatureId],
    schema: {
      config: _d3security.D3SecurityConfigSchema,
      secrets: _d3security.D3SecuritySecretsSchema
    },
    validators: [{
      type: _types.ValidatorType.CONFIG,
      validator: (0, _server.urlAllowListValidator)('url')
    }],
    renderParameterTemplates: _render.renderParameterTemplates
  };
}