"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executor = executor;
exports.getConnectorType = getConnectorType;
var _common = require("@kbn/actions-plugin/common");
var _cases_webhook = require("@kbn/connector-schemas/cases_webhook");
var _service = require("./service");
var _api = require("./api");
var _validators = require("./validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const supportedSubActions = ['pushToService'];

// connector type definition
function getConnectorType() {
  return {
    id: _cases_webhook.CONNECTOR_ID,
    minimumLicenseRequired: 'gold',
    name: _cases_webhook.CONNECTOR_NAME,
    validate: {
      config: {
        schema: _cases_webhook.ExternalIncidentServiceConfigurationSchema,
        customValidator: _validators.validateCasesWebhookConfig
      },
      secrets: {
        schema: _cases_webhook.ExternalIncidentServiceSecretConfigurationSchema
      },
      params: {
        schema: _cases_webhook.ExecutorParamsSchema
      },
      connector: _validators.validateConnector
    },
    executor,
    supportedFeatureIds: [_common.CasesConnectorFeatureId]
  };
}

// action executor
async function executor(execOptions) {
  const {
    actionId,
    configurationUtilities,
    params,
    logger,
    connectorUsageCollector
  } = execOptions;
  const {
    subAction,
    subActionParams
  } = params;
  let data;
  const externalService = (0, _service.createExternalService)(actionId, {
    config: execOptions.config,
    secrets: execOptions.secrets
  }, logger, configurationUtilities, connectorUsageCollector);
  if (!_api.api[subAction]) {
    const errorMessage = `[Action][ExternalService] Unsupported subAction type ${subAction}.`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }
  if (!supportedSubActions.includes(subAction)) {
    const errorMessage = `[Action][ExternalService] subAction ${subAction} not implemented.`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }
  if (subAction === 'pushToService') {
    const pushToServiceParams = subActionParams;
    data = await _api.api.pushToService({
      externalService,
      params: pushToServiceParams,
      logger
    });
    logger.debug(`response push to service for case id: ${data.id}`);
  }
  return {
    status: 'ok',
    data,
    actionId
  };
}