"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerConnectorTypesFromSpecs = registerConnectorTypesFromSpecs;
var _react = require("react");
var _get_icon = require("./get_icon");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function registerConnectorTypesFromSpecs({
  connectorTypeRegistry
}) {
  const connectorsSpecsImport = Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "connectorsSpecs" */
  '@kbn/connector-specs')));
  connectorsSpecsImport.then(({
    connectorsSpecs
  }) => {
    for (const spec of Object.values(connectorsSpecs)) {
      connectorTypeRegistry.register(createConnectorTypeFromSpec(spec));
    }
  });
}
const createConnectorTypeFromSpec = spec => ({
  // get generated schema from spec
  // const schema = generateSchema(spec);
  // pass this to the form builder. output should go into actionConnectorFields
  id: spec.metadata.id,
  actionTypeTitle: spec.metadata.displayName,
  selectMessage: spec.metadata.description,
  iconClass: (0, _get_icon.getIcon)(spec),
  // TODO: Implement the rest of the properties
  actionConnectorFields: null,
  actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve({
    default: () => null
  })),
  validateParams: async () => ({
    errors: {}
  })
});