"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSchema = void 0;
var _v = require("@kbn/zod/v4");
var _lib = require("@kbn/connector-specs/src/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateSchema = spec => {
  var _spec$schema;
  const config = (_spec$schema = spec.schema) !== null && _spec$schema !== void 0 ? _spec$schema : _v.z.object({});
  const secrets = _v.z.object({
    secrets: (0, _lib.generateSecretsSchemaFromSpec)(spec.authTypes)
  });
  return _v.z.object({
    ...config.shape,
    ...secrets.shape
  });
};
exports.generateSchema = generateSchema;