"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _constants = require("@kbn/connector-schemas/common/auth/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/webhook/webhook_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WebhookParamsFields = ({
  actionParams,
  actionConnector,
  editAction,
  index,
  messageVariables,
  errors
}) => {
  const {
    body
  } = actionParams;
  const webhookMethod = actionConnector && 'config' in actionConnector ? actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.config.method : undefined;
  const bodyIsOptional = webhookMethod && [_constants.WebhookMethods.GET, _constants.WebhookMethods.DELETE].includes(webhookMethod);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, webhookMethod && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "info",
    title: _i18n.i18n.translate('xpack.stackConnectors.components.webhook.noSetupRequiredCalloutTitle', {
      values: {
        method: webhookMethod.toUpperCase()
      },
      defaultMessage: 'This connector is configured to use HTTP {method} requests.'
    }),
    "data-test-subj": "placeholderCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    isOptionalField: bodyIsOptional,
    paramsProperty: 'body',
    inputTargetValue: body,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.webhook.bodyFieldLabel', {
      defaultMessage: 'Body'
    }),
    ariaLabel: _i18n.i18n.translate('xpack.stackConnectors.components.webhook.bodyCodeEditorAriaLabel', {
      defaultMessage: 'Code editor'
    }),
    errors: errors.body,
    onDocumentsChange: json => {
      editAction('body', json, index);
    },
    onBlur: () => {
      if (!body) {
        editAction('body', '', index);
      }
    },
    dataTestSubj: "actionJsonEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = WebhookParamsFields;
module.exports = exports.default;