"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/connector-schemas/tines/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getConnectorType() {
  return {
    id: _constants.CONNECTOR_ID,
    actionTypeTitle: _constants.CONNECTOR_NAME,
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.security.tines.config.selectMessageText', {
      defaultMessage: 'Send events to a Story.'
    }),
    validateParams: async actionParams => {
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        subAction: [],
        story: [],
        webhook: [],
        webhookUrl: [],
        body: []
      };
      const {
        subAction,
        subActionParams
      } = actionParams;
      if (subActionParams !== null && subActionParams !== void 0 && subActionParams.webhookUrl) {
        try {
          const parsedUrl = new URL(subActionParams.webhookUrl);
          if (parsedUrl.protocol !== 'https:') {
            errors.webhookUrl.push(translations.INVALID_PROTOCOL_WEBHOOK_URL);
          }
        } catch (err) {
          errors.webhookUrl.push(translations.INVALID_WEBHOOK_URL);
        }
      } else {
        var _subActionParams$webh, _subActionParams$webh2;
        if (!(subActionParams !== null && subActionParams !== void 0 && (_subActionParams$webh = subActionParams.webhook) !== null && _subActionParams$webh !== void 0 && _subActionParams$webh.storyId)) {
          errors.story.push(translations.STORY_REQUIRED);
        } else if (!(subActionParams !== null && subActionParams !== void 0 && (_subActionParams$webh2 = subActionParams.webhook) !== null && _subActionParams$webh2 !== void 0 && _subActionParams$webh2.id)) {
          errors.webhook.push(translations.WEBHOOK_REQUIRED);
        }
      }
      if (subAction === _constants.SUB_ACTION.TEST) {
        var _subActionParams$body;
        if (!(subActionParams !== null && subActionParams !== void 0 && (_subActionParams$body = subActionParams.body) !== null && _subActionParams$body !== void 0 && _subActionParams$body.length)) {
          errors.body.push(translations.BODY_REQUIRED);
        } else {
          try {
            JSON.parse(subActionParams.body);
          } catch {
            errors.body.push(translations.BODY_INVALID);
          }
        }
      }
      if (errors.story.length || errors.webhook.length || errors.body.length) return {
        errors
      };

      // The internal "subAction" param should always be valid, ensure it is only if "subActionParams" are valid
      if (!subAction) {
        errors.subAction.push(translations.ACTION_REQUIRED);
      } else if (subAction !== _constants.SUB_ACTION.RUN && subAction !== _constants.SUB_ACTION.TEST) {
        errors.subAction.push(translations.INVALID_ACTION);
      }
      return {
        errors
      };
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./tines_connector')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./tines_params'))))
  };
}