"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tlpOptions = exports.severityOptions = exports.eventActionOptions = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/connector-schemas/thehive/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const eventActionOptions = exports.eventActionOptions = [{
  value: _constants.SUB_ACTION.PUSH_TO_SERVICE,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectCreateCaseOptionLabel', {
    defaultMessage: 'Create case'
  })
}, {
  value: _constants.SUB_ACTION.CREATE_ALERT,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectCreateAlertOptionLabel', {
    defaultMessage: 'Create alert'
  })
}];
const severityOptions = exports.severityOptions = [{
  value: _constants.TheHiveSeverity.LOW,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectSeverityLowOptionLabel', {
    defaultMessage: 'LOW'
  })
}, {
  value: _constants.TheHiveSeverity.MEDIUM,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectSeverityMediumOptionLabel', {
    defaultMessage: 'MEDIUM'
  })
}, {
  value: _constants.TheHiveSeverity.HIGH,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectSeverityHighOptionLabel', {
    defaultMessage: 'HIGH'
  })
}, {
  value: _constants.TheHiveSeverity.CRITICAL,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectSeverityCriticalOptionLabel', {
    defaultMessage: 'CRITICAL'
  })
}];
const tlpOptions = exports.tlpOptions = [{
  value: _constants.TheHiveTLP.CLEAR,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectTlpClearOptionLabel', {
    defaultMessage: 'CLEAR'
  })
}, {
  value: _constants.TheHiveTLP.GREEN,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectTlpGreenOptionLabel', {
    defaultMessage: 'GREEN'
  })
}, {
  value: _constants.TheHiveTLP.AMBER,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectTlpAmberOptionLabel', {
    defaultMessage: 'AMBER'
  })
}, {
  value: _constants.TheHiveTLP.AMBER_STRICT,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectTlpAmberStrictOptionLabel', {
    defaultMessage: 'AMBER+STRICT'
  })
}, {
  value: _constants.TheHiveTLP.RED,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.thehive.eventSelectTlpRedOptionLabel', {
    defaultMessage: 'RED'
  })
}];