"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SW_SELECT_MESSAGE_TEXT = exports.SW_ACTION_TYPE_TITLE = void 0;
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/connector-schemas/swimlane/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SW_SELECT_MESSAGE_TEXT = exports.SW_SELECT_MESSAGE_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.selectMessageText', {
  defaultMessage: 'Create record in Swimlane'
});
const SW_ACTION_TYPE_TITLE = exports.SW_ACTION_TYPE_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.connectorTypeTitle', {
  defaultMessage: 'Create Swimlane Record'
});
function getConnectorType() {
  return {
    id: _constants.CONNECTOR_ID,
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: SW_SELECT_MESSAGE_TEXT,
    actionTypeTitle: SW_ACTION_TYPE_TITLE,
    validateParams: async actionParams => {
      var _actionParams$subActi, _actionParams$subActi2;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        'subActionParams.incident.ruleName': new Array(),
        'subActionParams.incident.alertId': new Array()
      };
      const validationResult = {
        errors
      };
      const hasIncident = actionParams.subActionParams && actionParams.subActionParams.incident;
      if (hasIncident && !((_actionParams$subActi = actionParams.subActionParams.incident.ruleName) !== null && _actionParams$subActi !== void 0 && _actionParams$subActi.length)) {
        errors['subActionParams.incident.ruleName'].push(translations.SW_REQUIRED_RULE_NAME);
      }
      if (hasIncident && !((_actionParams$subActi2 = actionParams.subActionParams.incident.alertId) !== null && _actionParams$subActi2 !== void 0 && _actionParams$subActi2.length)) {
        errors['subActionParams.incident.alertId'].push(translations.SW_REQUIRED_ALERT_ID);
      }
      return validationResult;
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./swimlane_connectors')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./swimlane_params'))))
  };
}