"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("../lib/servicenow/translations"));
var _use_get_choices = require("../lib/servicenow/use_get_choices");
var _helpers = require("../lib/servicenow/helpers");
var _deprecated_callout = require("../lib/servicenow/deprecated_callout");
var _additional_fields = require("../../common/components/additional_fields");
var _optional_field_label = require("../../common/optional_field_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/servicenow_sir/servicenow_sir_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useGetChoicesFields = ['category', 'subcategory', 'priority'];
const defaultFields = {
  category: [],
  subcategory: [],
  priority: []
};
const ServiceNowSIRParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  index,
  errors,
  messageVariables
}) => {
  var _actionConnector$id, _incident$priority, _incident$category, _incident$subcategory, _incident$correlation, _incident$correlation2, _incident$description, _actionParams$subActi2;
  const {
    docLinks,
    http,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const isDeprecatedActionConnector = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.isDeprecated;
  const actionConnectorRef = (0, _react.useRef)((_actionConnector$id = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) !== null && _actionConnector$id !== void 0 ? _actionConnector$id : '');
  const {
    incident,
    comments
  } = (0, _react.useMemo)(() => {
    var _actionParams$subActi;
    return (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : {
      incident: {},
      comments: []
    };
  }, [actionParams.subActionParams]);
  const [choices, setChoices] = (0, _react.useState)(defaultFields);
  const editSubActionProperty = (0, _react.useCallback)((key, value) => {
    const newProps = key !== 'comments' ? {
      incident: {
        ...incident,
        [key]: value
      },
      comments
    } : {
      incident,
      [key]: value
    };
    editAction('subActionParams', newProps, index);
  }, [comments, editAction, incident, index]);
  const editComment = (0, _react.useCallback)((key, value) => {
    editSubActionProperty(key, [{
      commentId: '1',
      comment: value
    }]);
  }, [editSubActionProperty]);
  const onChoicesSuccess = (0, _react.useCallback)(values => {
    setChoices(values.reduce((acc, value) => ({
      ...acc,
      [value.element]: [...(acc[value.element] != null ? acc[value.element] : []), value]
    }), defaultFields));
  }, []);
  const {
    isLoading: isLoadingChoices
  } = (0, _use_get_choices.useGetChoices)({
    http,
    toastNotifications: toasts,
    actionConnector,
    // Not having a memoized fields variable will cause infinitive API calls.
    fields: useGetChoicesFields,
    onSuccess: onChoicesSuccess
  });
  const categoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.category), [choices.category]);
  const priorityOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.priority), [choices.priority]);
  const subcategoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choices.subcategory.filter(subcategory => subcategory.dependent_value === incident.category)), [choices.subcategory, incident.category]);
  (0, _react.useEffect)(() => {
    if (actionConnector != null && actionConnectorRef.current !== actionConnector.id) {
      actionConnectorRef.current = actionConnector.id;
      editAction('subActionParams', {
        incident: {
          correlation_id: _helpers.DEFAULT_CORRELATION_ID
        },
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionConnector]);
  (0, _react.useEffect)(() => {
    if (!actionParams.subAction) {
      editAction('subAction', 'pushToService', index);
    }
    if (!actionParams.subActionParams) {
      editAction('subActionParams', {
        incident: {
          correlation_id: _helpers.DEFAULT_CORRELATION_ID
        },
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  const additionalFieldsOnChange = (0, _react.useCallback)(value => editSubActionProperty('additional_fields', value), [editSubActionProperty]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeprecatedActionConnector && /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 39
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, i18n.SECURITY_INCIDENT)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors['subActionParams.incident.short_description'],
    isInvalid: errors['subActionParams.incident.short_description'] !== undefined && Number(errors['subActionParams.incident.short_description'].length) > 0 && incident.short_description !== undefined,
    label: i18n.SHORT_DESCRIPTION_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'short_description',
    inputTargetValue: incident === null || incident === void 0 ? void 0 : incident.short_description,
    errors: errors['subActionParams.incident.short_description'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.PRIORITY_LABEL,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "prioritySelect",
    hasNoInitialSelection: true,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    options: priorityOptions,
    value: (_incident$priority = incident.priority) !== null && _incident$priority !== void 0 ? _incident$priority : undefined,
    onChange: e => editSubActionProperty('priority', e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.CATEGORY_LABEL,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "categorySelect",
    hasNoInitialSelection: true,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    options: categoryOptions,
    value: (_incident$category = incident.category) !== null && _incident$category !== void 0 ? _incident$category : undefined,
    onChange: e => {
      editAction('subActionParams', {
        incident: {
          ...incident,
          category: e.target.value,
          subcategory: null
        },
        comments
      }, index);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }, (subcategoryOptions === null || subcategoryOptions === void 0 ? void 0 : subcategoryOptions.length) > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.SUBCATEGORY_LABEL,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "subcategorySelect",
    hasNoInitialSelection: true,
    isLoading: isLoadingChoices,
    disabled: isLoadingChoices,
    options: subcategoryOptions
    // Needs an empty string instead of undefined to select the blank option when changing categories
    ,
    value: (_incident$subcategory = incident.subcategory) !== null && _incident$subcategory !== void 0 ? _incident$subcategory : '',
    onChange: e => editSubActionProperty('subcategory', e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 7
    }
  }), !isDeprecatedActionConnector && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.CORRELATION_ID,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.alerting.serviceNowSIRAction,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.stackConnectors.components.serviceNowSIR.correlationIDHelpLabel",
      defaultMessage: "Identifier for updating incidents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 21
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'correlation_id',
    inputTargetValue: (_incident$correlation = incident === null || incident === void 0 ? void 0 : incident.correlation_id) !== null && _incident$correlation !== void 0 ? _incident$correlation : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.CORRELATION_DISPLAY,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'correlation_display',
    inputTargetValue: (_incident$correlation2 = incident === null || incident === void 0 ? void 0 : incident.correlation_display) !== null && _incident$correlation2 !== void 0 ? _incident$correlation2 : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'description',
    inputTargetValue: (_incident$description = incident.description) !== null && _incident$description !== void 0 ? _incident$description : undefined,
    label: i18n.DESCRIPTION_LABEL,
    isOptionalField: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editComment,
    messageVariables: messageVariables,
    paramsProperty: 'comments',
    inputTargetValue: comments && comments.length > 0 ? comments[0].comment : undefined,
    label: i18n.COMMENTS_LABEL,
    isOptionalField: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 7
    }
  }), !isDeprecatedActionConnector && /*#__PURE__*/_react.default.createElement(_additional_fields.AdditionalFields, {
    value: (_actionParams$subActi2 = actionParams.subActionParams) === null || _actionParams$subActi2 === void 0 ? void 0 : _actionParams$subActi2.incident.additional_fields,
    messageVariables: messageVariables,
    errors: errors['subActionParams.incident.additional_fields'],
    onChange: additionalFieldsOnChange,
    isOptionalField: true,
    helpText: i18n.ADDITIONAL_FIELDS_HELP_SERVICENOW_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 9
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = ServiceNowSIRParamsFields;
module.exports = exports.default;