"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICENOW_SIR_DESC = void 0;
exports.getServiceNowSIRConnectorType = getServiceNowSIRConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/connector-schemas/servicenow/constants");
var _constants2 = require("@kbn/connector-schemas/servicenow_sir/constants");
var _helpers = require("../lib/servicenow/helpers");
var _validate_json = require("../lib/validate_json");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SERVICENOW_SIR_DESC = exports.SERVICENOW_SIR_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowSIR.selectMessageText', {
  defaultMessage: 'Create an incident in ServiceNow SecOps.'
});
function getServiceNowSIRConnectorType() {
  return {
    id: _constants2.CONNECTOR_ID,
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: SERVICENOW_SIR_DESC,
    actionTypeTitle: _constants2.CONNECTOR_NAME,
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../lib/servicenow/servicenow_connectors')))),
    validateParams: async actionParams => {
      var _actionParams$subActi, _actionParams$subActi2, _actionParams$subActi3;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('../lib/servicenow/translations')));
      const errors = {
        'subActionParams.incident.short_description': new Array(),
        'subActionParams.incident.additional_fields': new Array()
      };
      const validationResult = {
        errors
      };
      if (actionParams.subActionParams && actionParams.subActionParams.incident && !((_actionParams$subActi = actionParams.subActionParams.incident.short_description) !== null && _actionParams$subActi !== void 0 && _actionParams$subActi.length)) {
        errors['subActionParams.incident.short_description'].push(translations.TITLE_REQUIRED);
      }
      const jsonErrors = (0, _validate_json.validateJSON)({
        value: (_actionParams$subActi2 = actionParams.subActionParams) === null || _actionParams$subActi2 === void 0 ? void 0 : (_actionParams$subActi3 = _actionParams$subActi2.incident) === null || _actionParams$subActi3 === void 0 ? void 0 : _actionParams$subActi3.additional_fields,
        maxProperties: _constants.MAX_ADDITIONAL_FIELDS_LENGTH
      });
      if (jsonErrors) {
        errors['subActionParams.incident.additional_fields'] = [jsonErrors];
      }
      return validationResult;
    },
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./servicenow_sir_params')))),
    customConnectorSelectItem: {
      getText: _helpers.getConnectorDescriptiveTitle,
      getComponent: _helpers.getSelectedConnectorIcon
    }
  };
}