"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICENOW_ITOM_DESC = void 0;
exports.getServiceNowITOMConnectorType = getServiceNowITOMConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/connector-schemas/servicenow_itom/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SERVICENOW_ITOM_DESC = exports.SERVICENOW_ITOM_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowITOM.selectMessageText', {
  defaultMessage: 'Create an event in ServiceNow ITOM.'
});
function getServiceNowITOMConnectorType() {
  return {
    id: _constants.CONNECTOR_ID,
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: SERVICENOW_ITOM_DESC,
    actionTypeTitle: _constants.CONNECTOR_NAME,
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../lib/servicenow/servicenow_connectors_no_app')))),
    validateParams: async actionParams => {
      var _actionParams$subActi;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('../lib/servicenow/translations')));
      const errors = {
        severity: new Array(),
        additional_info: new Array()
      };
      if ((actionParams === null || actionParams === void 0 ? void 0 : (_actionParams$subActi = actionParams.subActionParams) === null || _actionParams$subActi === void 0 ? void 0 : _actionParams$subActi.severity) == null) {
        errors.severity.push(translations.SEVERITY_REQUIRED);
      }
      try {
        var _actionParams$subActi2;
        JSON.parse(((_actionParams$subActi2 = actionParams.subActionParams) === null || _actionParams$subActi2 === void 0 ? void 0 : _actionParams$subActi2.additional_info) || '{}');
      } catch (error) {
        errors.additional_info.push(translations.ADDITIONAL_INFO_JSON_ERROR);
      }
      return {
        errors
      };
    },
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./servicenow_itom_params'))))
  };
}