"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/pagerduty/pagerduty_connectors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField,
  urlField
} = _helpers.fieldValidators;
const getApiURLConfig = () => ({
  label: i18n.API_URL_LABEL,
  labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, i18n.OPTIONAL_LABEL),
  validations: [{
    validator: args => {
      const {
        value
      } = args;
      /**
       * The field is optional so if it is empty
       * we do not validate
       */
      if ((0, _lodash.isEmpty)(value)) {
        return;
      }
      return urlField(i18n.API_URL_INVALID)(args);
    }
  }]
});
const getRoutingKeyConfig = docLinks => ({
  label: i18n.INTEGRATION_KEY_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.alerting.pagerDutyAction,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.pagerDuty.routingKeyNameHelpLabel",
    defaultMessage: "Configure a PagerDuty account",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  })),
  validations: [{
    validator: emptyField(i18n.INTEGRATION_KEY_REQUIRED)
  }]
});
const PagerDutyActionConnectorFields = ({
  readOnly,
  isEdit
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.apiUrl",
    component: _components.Field,
    config: getApiURLConfig(),
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'pagerdutyApiUrlInput',
        fullWidth: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.routingKey",
    config: getRoutingKeyConfig(docLinks),
    component: _components.Field,
    componentProps: {
      euiFieldProps: {
        readOnly,
        'data-test-subj': 'pagerdutyRoutingKeyInput',
        fullWidth: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = PagerDutyActionConnectorFields;
module.exports = exports.default;