"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _constants = require("@kbn/connector-schemas/opsgenie/constants");
var _opsgenie = require("../../../common/opsgenie");
var _constants2 = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SELECT_MESSAGE = _i18n.i18n.translate('xpack.stackConnectors.components.opsgenie.selectMessageText', {
  defaultMessage: 'Create or close an alert in Opsgenie.'
});
const getConnectorType = () => {
  return {
    id: _constants.CONNECTOR_ID,
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: SELECT_MESSAGE,
    actionTypeTitle: _constants.CONNECTOR_NAME,
    validateParams,
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./connector')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./params')))),
    defaultActionParams: {
      subAction: _constants.SUB_ACTION.CreateAlert,
      subActionParams: {
        alias: _constants2.DEFAULT_ALIAS,
        tags: [_opsgenie.RULE_TAGS_TEMPLATE]
      }
    },
    defaultRecoveredActionParams: {
      subAction: _constants.SUB_ACTION.CloseAlert,
      subActionParams: {
        alias: _constants2.DEFAULT_ALIAS
      }
    }
  };
};
exports.getConnectorType = getConnectorType;
const validateParams = async actionParams => {
  var _actionParams$subActi5, _actionParams$subActi6;
  const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
  const errors = {
    'subActionParams.message': new Array(),
    'subActionParams.alias': new Array(),
    jsonEditorError: new Array()
  };
  const validationResult = {
    errors
  };
  if (actionParams.subAction === _constants.SUB_ACTION.CreateAlert) {
    var _actionParams$subActi, _actionParams$subActi2, _actionParams$subActi3, _actionParams$subActi4;
    if (!(actionParams !== null && actionParams !== void 0 && (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 && (_actionParams$subActi2 = _actionParams$subActi.message) !== null && _actionParams$subActi2 !== void 0 && _actionParams$subActi2.length)) {
      errors['subActionParams.message'].push(translations.MESSAGE_IS_REQUIRED);
    } else if ((0, _lodash.isEmpty)(actionParams === null || actionParams === void 0 ? void 0 : (_actionParams$subActi3 = actionParams.subActionParams) === null || _actionParams$subActi3 === void 0 ? void 0 : (_actionParams$subActi4 = _actionParams$subActi3.message) === null || _actionParams$subActi4 === void 0 ? void 0 : _actionParams$subActi4.trim())) {
      errors['subActionParams.message'].push(translations.MESSAGE_NON_WHITESPACE);
    }
  }
  if (actionParams.subAction === _constants.SUB_ACTION.CloseAlert && !(actionParams !== null && actionParams !== void 0 && (_actionParams$subActi5 = actionParams.subActionParams) !== null && _actionParams$subActi5 !== void 0 && (_actionParams$subActi6 = _actionParams$subActi5.alias) !== null && _actionParams$subActi6 !== void 0 && _actionParams$subActi6.length)) {
    errors['subActionParams.alias'].push(translations.ALIAS_IS_REQUIRED);
  }
  if (actionParams.jsonEditorError) {
    // This error doesn't actually get displayed it is used to cause the run/save button to fail within the action form
    errors.jsonEditorError.push(translations.JSON_EDITOR_ERROR);
  }
  return validationResult;
};