"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/opsgenie/connector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const configFormSchema = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  defaultValue: _constants.DEFAULT_URL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Opsgenie URL. For more information on the URL, refer to the {opsgenieAPIUrlDocs}.",
    id: "xpack.stackConnectors.components.opsgenie.apiUrlDocumentation",
    values: {
      opsgenieAPIUrlDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://docs.opsgenie.com/docs/alert-api",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 13
        }
      }, i18n.OPSGENIE_DOCUMENTATION)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  })
}];
const secretsFormSchema = [{
  id: 'apiKey',
  label: i18n.API_KEY_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Opsgenie API authentication key for HTTP Basic authentication. For more details about generating Opsgenie API keys, refer to the {opsgenieAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.opsgenie.apiKeyDocumentation",
    values: {
      opsgenieAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://support.atlassian.com/opsgenie/docs/create-a-default-api-integration",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 13
        }
      }, i18n.OPSGENIE_DOCUMENTATION)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  })
}];
const OpsgenieConnectorFields = ({
  readOnly,
  isEdit
}) => {
  return /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: configFormSchema,
    secretsFormSchema: secretsFormSchema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = OpsgenieConnectorFields;
module.exports = exports.default;