"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formSerializer = exports.formDeserializer = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Same as the webhook-type connectors (../lib/webhook/form_serialization.ts),
// but might diverge in the future
const formDeserializer = data => {
  var _data$config$headers, _data$config;
  if (!data.actionTypeId) {
    // Hook form lib can call deserializer *also* while editing the form (indicated by actionTypeId
    // still being undefined). Changing the reference of form data subproperties causes problems
    // with the UseArray that is used to edit the headers. For this reason, we leave the data unchanged.
    return data;
  }
  const configHeaders = Object.entries((_data$config$headers = data === null || data === void 0 ? void 0 : (_data$config = data.config) === null || _data$config === void 0 ? void 0 : _data$config.headers) !== null && _data$config$headers !== void 0 ? _data$config$headers : {}).map(([key, value]) => ({
    key,
    value,
    type: 'config'
  }));
  return {
    ...data,
    config: {
      ...data.config,
      headers: (0, _lodash.isEmpty)(configHeaders) ? undefined : configHeaders
    },
    __internal__: {
      headers: configHeaders
    }
  };
};
exports.formDeserializer = formDeserializer;
const formSerializer = formData => {
  var _webhookFormData$conf, _webhookFormData$conf2;
  const webhookFormData = formData;
  const configHeaders = ((_webhookFormData$conf = webhookFormData === null || webhookFormData === void 0 ? void 0 : (_webhookFormData$conf2 = webhookFormData.config) === null || _webhookFormData$conf2 === void 0 ? void 0 : _webhookFormData$conf2.headers) !== null && _webhookFormData$conf !== void 0 ? _webhookFormData$conf : []).reduce((acc, header) => ({
    ...acc,
    [header.key]: header.value
  }), {});
  return {
    ...formData,
    config: {
      ...formData.config,
      headers: (0, _lodash.isEmpty)(configHeaders) ? undefined : configHeaders
    },
    secrets: {
      ...formData.secrets,
      secretHeaders: undefined
    }
  };
};
exports.formSerializer = formSerializer;