"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DashboardLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_dashboard = require("../lib/gen_ai/use_get_dashboard");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/openai/dashboard_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// tested from ./connector.test.tsx
const DashboardLink = ({
  connectorId,
  connectorName,
  selectedProvider = 'OpenAI'
}) => {
  const {
    dashboardUrl
  } = (0, _use_get_dashboard.useGetDashboard)({
    connectorId,
    selectedProvider
  });
  const {
    services: {
      application: {
        navigateToUrl
      }
    }
  } = (0, _public.useKibana)();
  const onClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (dashboardUrl) {
      navigateToUrl(dashboardUrl);
    }
  }, [dashboardUrl, navigateToUrl]);
  return dashboardUrl != null ?
  /*#__PURE__*/
  // href gives us right click -> open in new tab
  // onclick prevents page reload
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "link-gen-ai-token-dashboard",
    onClick: onClick,
    href: dashboardUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, i18n.USAGE_DASHBOARD_LINK(selectedProvider, connectorName))) : null;
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.DashboardLink = DashboardLink;