"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.providerOptions = exports.otherOpenAiConfig = exports.openAiSecrets = exports.openAiConfig = exports.getOtherOpenAiSecrets = exports.getDefaultBody = exports.azureAiSecrets = exports.azureAiConfig = exports.DEFAULT_URL_AZURE = exports.DEFAULT_URL = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("@kbn/connector-schemas/openai/constants");
var _genai_connectors = require("../../common/genai_connectors");
var commonI18n = _interopRequireWildcard(require("../../common/genai_connectors/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/openai/constants.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_URL = exports.DEFAULT_URL = 'https://api.openai.com/v1/chat/completions';
const DEFAULT_URL_AZURE = exports.DEFAULT_URL_AZURE = 'https://{your-resource-name}.openai.azure.com/openai/deployments/{deployment-id}/chat/completions?api-version={api-version}';
const DEFAULT_BODY = `{
    "messages": [{
        "role":"user",
        "content":"Hello world"
    }]
}`;
const DEFAULT_BODY_AZURE = `{
    "messages": [{
        "role":"user",
        "content":"Hello world"
    }]
}`;
const DEFAULT_BODY_OTHER = defaultModel => `{
    "model": "${defaultModel}",
    "messages": [{
        "role":"user",
        "content":"Hello world"
    }]
}`;
const getDefaultBody = config => {
  if (!config) {
    // default to OpenAiProviderType.OpenAi sample data
    return DEFAULT_BODY;
  }
  if ((config === null || config === void 0 ? void 0 : config.apiProvider) === _constants.OpenAiProviderType.Other) {
    // update sample data if Other (OpenAI Compatible Service)
    return config.defaultModel ? DEFAULT_BODY_OTHER(config.defaultModel) : DEFAULT_BODY;
  }
  if ((config === null || config === void 0 ? void 0 : config.apiProvider) === _constants.OpenAiProviderType.AzureAi) {
    // update sample data if AzureAi
    return DEFAULT_BODY_AZURE;
  }
  // default to OpenAiProviderType.OpenAi sample data
  return DEFAULT_BODY;
};
exports.getDefaultBody = getDefaultBody;
const openAiConfig = exports.openAiConfig = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  defaultValue: DEFAULT_URL,
  requireTld: false,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The OpenAI API endpoint URL. For more information on the URL, refer to the {genAiAPIUrlDocs}.",
    id: "xpack.stackConnectors.components.genAi.openAiDocumentation",
    values: {
      genAiAPIUrlDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "open-ai-api-doc",
        href: "https://platform.openai.com/docs/api-reference",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 13
        }
      }, `${i18n.OPENAI} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  })
}, {
  id: 'defaultModel',
  label: i18n.DEFAULT_MODEL_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "If a request does not include a model, it uses the default.",
    id: "xpack.stackConnectors.components.genAi.openAiDocumentationModel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }),
  defaultValue: _constants.DEFAULT_MODEL
}, _genai_connectors.contextWindowLengthField, _genai_connectors.temperatureField, {
  id: 'organizationId',
  label: i18n.ORG_ID_LABEL,
  isRequired: false,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "For users who belong to multiple organizations. Organization IDs can be found on your Organization settings page.",
    id: "xpack.stackConnectors.components.genAi.openAiOrgId",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }),
  euiFieldProps: {
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }, commonI18n.OPTIONAL_LABEL)
  }
}, {
  id: 'projectId',
  label: i18n.PROJECT_ID_LABEL,
  isRequired: false,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "For users who are accessing their projects through their legacy user API key. Project IDs can be found on your General settings page by selecting the specific project.",
    id: "xpack.stackConnectors.components.genAi.openAiProjectId",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }),
  euiFieldProps: {
    autocomplete: 'new-password',
    autoComplete: 'new-password',
    onFocus: event => {
      event.target.setAttribute('autocomplete', 'new-password');
    },
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 9
      }
    }, commonI18n.OPTIONAL_LABEL)
  }
}];
const azureAiConfig = exports.azureAiConfig = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  requireTld: false,
  defaultValue: DEFAULT_URL_AZURE,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Azure OpenAI API endpoint URL. For more information on the URL, refer to the {genAiAPIUrlDocs}.",
    id: "xpack.stackConnectors.components.genAi.azureAiDocumentation",
    values: {
      genAiAPIUrlDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "azure-ai-api-doc",
        href: "https://learn.microsoft.com/en-us/azure/cognitive-services/openai/reference",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 13
        }
      }, `${i18n.AZURE_AI} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  })
}, _genai_connectors.contextWindowLengthField, _genai_connectors.temperatureField];
const otherOpenAiConfig = exports.otherOpenAiConfig = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  requireTld: false,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Other (OpenAI Compatible Service) endpoint URL. For more information on the URL, refer to the {genAiAPIUrlDocs}.",
    id: "xpack.stackConnectors.components.genAi.otherOpenAiDocumentation",
    values: {
      genAiAPIUrlDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "other-ai-api-doc",
        href: "https://www.elastic.co/guide/en/security/current/connect-to-byo-llm.html",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 13
        }
      }, `${i18n.OTHER_OPENAI} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  })
}, {
  id: 'defaultModel',
  label: i18n.DEFAULT_MODEL_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "If a request does not include a model, it uses the default.",
    id: "xpack.stackConnectors.components.genAi.otherOpenAiDocumentationModel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  })
}, _genai_connectors.contextWindowLengthField, _genai_connectors.temperatureField];
const openAiSecrets = exports.openAiSecrets = [{
  id: 'apiKey',
  label: i18n.API_KEY_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The OpenAI API authentication key for HTTP Basic authentication. For more details about generating OpenAI API keys, refer to the {genAiAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.genAi.openAiApiKeyDocumentation",
    values: {
      genAiAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "open-ai-api-keys-doc",
        href: "https://platform.openai.com/account/api-keys",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 13
        }
      }, `${i18n.OPENAI} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 7
    }
  })
}];
const azureAiSecrets = exports.azureAiSecrets = [{
  id: 'apiKey',
  label: i18n.API_KEY_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Azure API key for HTTP Basic authentication. For more details about generating Azure OpenAI API keys, refer to the {genAiAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.genAi.azureAiApiKeyDocumentation",
    values: {
      genAiAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "azure-ai-api-keys-doc",
        href: "https://learn.microsoft.com/en-us/azure/cognitive-services/openai/reference#authentication",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 13
        }
      }, `${i18n.AZURE_AI} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 7
    }
  })
}];
const getOtherOpenAiSecrets = (isRequired = true) => [{
  id: 'apiKey',
  label: i18n.API_KEY_LABEL,
  isPasswordField: true,
  isRequired,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Other (OpenAI Compatible Service) API key for HTTP Basic authentication. For more details about generating Other model API keys, refer to the {genAiAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.genAi.otherOpenAiApiKeyDocumentation",
    values: {
      genAiAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "other-ai-api-keys-doc",
        href: "https://www.elastic.co/guide/en/security/current/connect-to-byo-llm.html",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 269,
          columnNumber: 13
        }
      }, `${i18n.OTHER_OPENAI} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  })
}];
exports.getOtherOpenAiSecrets = getOtherOpenAiSecrets;
const providerOptions = exports.providerOptions = [{
  value: _constants.OpenAiProviderType.OpenAi,
  text: i18n.OPENAI,
  label: i18n.OPENAI
}, {
  value: _constants.OpenAiProviderType.AzureAi,
  text: i18n.AZURE_AI,
  label: i18n.AZURE_AI
}, {
  value: _constants.OpenAiProviderType.Other,
  text: i18n.OTHER_OPENAI,
  label: i18n.OTHER_OPENAI
}];