"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _constants = require("@kbn/connector-schemas/openai/constants");
var _translations = _interopRequireWildcard(require("../../common/auth/translations"));
var i18nAuth = _translations;
var _dashboard_link = _interopRequireDefault(require("./dashboard_link"));
var i18n = _interopRequireWildcard(require("./translations"));
var _constants2 = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/openai/connector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const ConnectorFields = ({
  readOnly,
  isEdit
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getFieldDefaultValue
  } = (0, _hook_form_lib.useFormContext)();
  const [{
    config,
    __internal__,
    id,
    name
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['config.apiProvider', '__internal__.hasHeaders', '__internal__.hasPKI']
  });
  const hasHeaders = __internal__ != null ? __internal__.hasHeaders : false;
  const hasHeadersDefaultValue = !!getFieldDefaultValue('config.headers');
  const hasPKI = __internal__ != null ? __internal__.hasPKI : false;
  const hasPKIDefaultValue = (0, _react.useMemo)(() => {
    return !!getFieldDefaultValue('config.verificationMode');
  }, [getFieldDefaultValue]);
  const selectedProviderDefaultValue = (0, _react.useMemo)(() => {
    var _getFieldDefaultValue;
    return (_getFieldDefaultValue = getFieldDefaultValue('config.apiProvider')) !== null && _getFieldDefaultValue !== void 0 ? _getFieldDefaultValue : _constants.OpenAiProviderType.OpenAi;
  }, [getFieldDefaultValue]);
  const verificationModeOptions = [{
    value: 'full',
    text: i18n.VERIFICATION_MODE_FULL
  }, {
    value: 'certificate',
    text: i18n.VERIFICATION_MODE_CERTIFICATE
  }, {
    value: 'none',
    text: i18n.VERIFICATION_MODE_NONE
  }];
  const otherOpenAiSecrets = (0, _react.useMemo)(() => (0, _constants2.getOtherOpenAiSecrets)(!hasPKI), [hasPKI]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.apiProvider",
    component: _components.SelectField,
    config: {
      label: i18n.API_PROVIDER_LABEL,
      defaultValue: selectedProviderDefaultValue,
      validations: [{
        validator: emptyField(i18n.API_PROVIDER_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'config.apiProvider-select',
        options: _constants2.providerOptions,
        fullWidth: true,
        hasNoInitialSelection: false,
        disabled: readOnly,
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }), config != null && config.apiProvider === _constants.OpenAiProviderType.OpenAi && /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: _constants2.openAiConfig,
    secretsFormSchema: _constants2.openAiSecrets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), config != null && config.apiProvider === _constants.OpenAiProviderType.AzureAi && /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: _constants2.azureAiConfig,
    secretsFormSchema: _constants2.azureAiSecrets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }), config != null && config.apiProvider === _constants.OpenAiProviderType.Other && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: _constants2.otherOpenAiConfig,
    secretsFormSchema: otherOpenAiSecrets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.enableNativeFunctionCalling",
    component: _components.ToggleField,
    config: {
      label: i18n.USE_NATIVE_FUNCTION_CALLING_LABEL,
      helpText: i18n.USE_NATIVE_FUNCTION_CALLING_DESC,
      defaultValue: false
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'config.enableNativeFunctionCallingSwitch'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "__internal__.hasPKI",
    component: _components.ToggleField,
    config: {
      defaultValue: hasPKIDefaultValue,
      label: i18n.PKI_MODE_LABEL
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'openAIViewPKISwitch'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }), hasPKI && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.verificationMode",
    component: _components.SelectField,
    config: {
      label: i18n.VERIFICATION_MODE_LABEL,
      validations: [{
        validator: emptyField(_translations.CRT_REQUIRED)
      }],
      defaultValue: 'full',
      helpText: i18n.VERIFICATION_MODE_DESC
    },
    componentProps: {
      euiFieldProps: {
        options: verificationModeOptions,
        'data-test-subj': 'verificationModeSelect',
        fullWidth: true,
        disabled: readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.certificateData",
    config: {
      label: i18n.CERT_DATA_LABEL,
      validations: [{
        validator: emptyField(_translations.CRT_REQUIRED)
      }]
    },
    component: _components.FilePickerField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'openAISSLCRTInput',
        display: 'default',
        accept: '.crt,.cert,.cer,.pem'
      }
    },
    helpText: i18n.CERT_DATA_DESC,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.privateKeyData",
    config: {
      label: i18n.KEY_DATA_LABEL,
      validations: [{
        validator: emptyField(_translations.KEY_REQUIRED)
      }]
    },
    component: _components.FilePickerField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'openAISSLKEYInput',
        display: 'default',
        accept: '.key,.pem'
      }
    },
    helpText: i18n.KEY_DATA_DESC,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "secrets.caData",
    config: {
      label: i18n.CA_DATA_LABEL
    },
    component: _components.FilePickerField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'openAISSLCAInput',
        display: 'default',
        accept: '.crt,.cert,.cer,.pem'
      }
    },
    helpText: i18n.CA_DATA_DESC,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "__internal__.hasHeaders",
    component: _components.ToggleField,
    config: {
      defaultValue: hasHeadersDefaultValue,
      label: i18nAuth.HEADERS_SWITCH
    },
    componentProps: {
      euiFieldProps: {
        disabled: readOnly,
        'data-test-subj': 'openAIViewHeadersSwitch'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 7
    }
  }), hasHeaders && /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseArray, {
    path: "config.headers",
    initialNumberOfItems: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 9
    }
  }, ({
    items,
    addItem,
    removeItem
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      "data-test-subj": "openAIHeaderText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 19
      }
    }, i18nAuth.HEADERS_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 17
      }
    }), items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: item.id,
      css: {
        marginTop: euiTheme.size.s
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
      path: `${item.path}.key`,
      config: {
        label: i18nAuth.KEY_LABEL
      },
      component: _components.TextField
      // This is needed because when you delete
      // a row and add a new one, the stale values will appear
      ,
      readDefaultValueOnForm: !item.isNew,
      componentProps: {
        euiFieldProps: {
          readOnly,
          ['data-test-subj']: 'openAIHeadersKeyInput'
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 23
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
      path: `${item.path}.value`,
      config: {
        label: i18nAuth.VALUE_LABEL
      },
      component: _components.TextField,
      readDefaultValueOnForm: !item.isNew,
      componentProps: {
        euiFieldProps: {
          readOnly,
          ['data-test-subj']: 'openAIHeadersValueInput'
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 23
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "danger",
      onClick: () => removeItem(item.id),
      iconType: "minusInCircle",
      "aria-label": i18nAuth.DELETE_BUTTON,
      css: {
        marginTop: '28px'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 23
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "plusInCircle",
      onClick: addItem,
      "data-test-subj": "openAIAddHeaderButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 17
      }
    }, i18nAuth.ADD_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 17
      }
    }));
  }), isEdit && /*#__PURE__*/_react.default.createElement(_dashboard_link.default, {
    connectorId: id,
    connectorName: name,
    selectedProvider: selectedProviderDefaultValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 9
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = ConnectorFields;
module.exports = exports.default;