"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/connector-schemas/inference/constants");
var _form_serialization = require("./form_serialization");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getConnectorType() {
  return {
    id: _constants.CONNECTOR_ID,
    iconClass: 'sparkles',
    isExperimental: true,
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.components.inference.selectMessageText', {
      defaultMessage: 'Send requests to AI providers such as Amazon Bedrock, OpenAI and more.'
    }),
    selectMessagePreconfigured: _i18n.i18n.translate('xpack.stackConnectors.components.inference.selectMessagePreconfiguredText', {
      defaultMessage: 'Use the Elastic Managed LLM for your chat and RAG use cases.'
    }),
    actionTypeTitle: _constants.CONNECTOR_NAME,
    validateParams: async actionParams => {
      const {
        subAction,
        subActionParams
      } = actionParams;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        input: [],
        body: [],
        subAction: [],
        inputType: [],
        query: []
      };
      if (subAction === _constants.SUB_ACTION.UNIFIED_COMPLETION || subAction === _constants.SUB_ACTION.UNIFIED_COMPLETION_STREAM || subAction === _constants.SUB_ACTION.UNIFIED_COMPLETION_ASYNC_ITERATOR) {
        var _parsedBody$messages;
        let parsedBody;
        try {
          // Attempt to parse the body only if it is a string, otherwise it is already an object
          parsedBody = typeof subActionParams.body === 'string' ? JSON.parse(subActionParams.body) : subActionParams.body;
        } catch {
          errors.body.push(translations.BODY_INVALID);
        }
        if (parsedBody && (!((_parsedBody$messages = parsedBody.messages) !== null && _parsedBody$messages !== void 0 && _parsedBody$messages.length) || !Array.isArray(subActionParams.body.messages))) {
          errors.body.push(translations.getRequiredMessage('Messages'));
        }
      }
      if (subAction === _constants.SUB_ACTION.COMPLETION || subAction === _constants.SUB_ACTION.RERANK || subAction === _constants.SUB_ACTION.TEXT_EMBEDDING || subAction === _constants.SUB_ACTION.SPARSE_EMBEDDING) {
        var _subActionParams$inpu;
        if (!((_subActionParams$inpu = subActionParams.input) !== null && _subActionParams$inpu !== void 0 && _subActionParams$inpu.length)) {
          errors.input.push(translations.getRequiredMessage('Input'));
        }
      }
      if (subAction === _constants.SUB_ACTION.RERANK) {
        var _query;
        if (!Array.isArray(subActionParams.input)) {
          errors.input.push(translations.INPUT_INVALID);
        }
        if (!((_query = subActionParams.query) !== null && _query !== void 0 && _query.length)) {
          errors.query.push(translations.getRequiredMessage('Query'));
        }
      }
      if (subAction === _constants.SUB_ACTION.TEXT_EMBEDDING) {
        var _inputType;
        if (!((_inputType = subActionParams.inputType) !== null && _inputType !== void 0 && _inputType.length)) {
          errors.inputType.push(translations.getRequiredMessage('Input type'));
        }
      }
      if (errors.input.length) return {
        errors
      };

      // The internal "subAction" param should always be valid, ensure it is only if "subActionParams" are valid
      if (!subAction) {
        errors.subAction.push(translations.getRequiredMessage('Action'));
      } else if (![_constants.SUB_ACTION.UNIFIED_COMPLETION, _constants.SUB_ACTION.UNIFIED_COMPLETION_STREAM, _constants.SUB_ACTION.UNIFIED_COMPLETION_ASYNC_ITERATOR, _constants.SUB_ACTION.SPARSE_EMBEDDING, _constants.SUB_ACTION.RERANK, _constants.SUB_ACTION.TEXT_EMBEDDING, _constants.SUB_ACTION.COMPLETION].includes(subAction)) {
        errors.subAction.push(translations.INVALID_ACTION);
      }
      return {
        errors
      };
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./connector')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./params')))),
    actionReadOnlyExtraComponent: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./usage_cost_message')))),
    connectorForm: {
      serializer: _form_serialization.formSerializer,
      deserializer: _form_serialization.formDeserializer,
      hideSettingsTitle: true
    }
  };
}