"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formSerializer = exports.formDeserializer = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_ALLOCATIONS = 0;
const DEFAULT_NUM_THREADS = 1;
const formSerializer = data => {
  var _data$config;
  const providerConfig = (_data$config = data.config) === null || _data$config === void 0 ? void 0 : _data$config.providerConfig;
  if (data && providerConfig) {
    const {
      max_number_of_allocations: maxAllocations,
      headers,
      ...restProviderConfig
    } = providerConfig || {};
    return {
      ...data,
      config: {
        ...data.config,
        providerConfig: {
          ...restProviderConfig,
          ...(maxAllocations ? {
            adaptive_allocations: {
              enabled: true,
              min_number_of_allocations: MIN_ALLOCATIONS,
              ...(maxAllocations ? {
                max_number_of_allocations: maxAllocations
              } : {})
            },
            // Temporary solution until the endpoint is updated to no longer require it and to set its own default for this value
            num_threads: DEFAULT_NUM_THREADS
          } : {})
        },
        ...(headers ? {
          headers
        } : {})
      }
    };
  }
  return data;
};
exports.formSerializer = formSerializer;
const formDeserializer = data => {
  var _data$config2, _data$config2$provide, _data$config2$provide2, _data$config3;
  if ((_data$config2 = data.config) !== null && _data$config2 !== void 0 && (_data$config2$provide = _data$config2.providerConfig) !== null && _data$config2$provide !== void 0 && (_data$config2$provide2 = _data$config2$provide.adaptive_allocations) !== null && _data$config2$provide2 !== void 0 && _data$config2$provide2.max_number_of_allocations || (_data$config3 = data.config) !== null && _data$config3 !== void 0 && _data$config3.headers) {
    var _data$config$provider, _data$config$provider2;
    const {
      headers,
      ...restConfig
    } = data.config;
    const maxAllocations = (_data$config$provider = data.config.providerConfig) === null || _data$config$provider === void 0 ? void 0 : (_data$config$provider2 = _data$config$provider.adaptive_allocations) === null || _data$config$provider2 === void 0 ? void 0 : _data$config$provider2.max_number_of_allocations;
    return {
      ...data,
      config: {
        ...restConfig,
        providerConfig: {
          ...data.config.providerConfig,
          ...(headers ? {
            headers
          } : {}),
          ...(maxAllocations ?
          // remove the adaptive_allocations from the data config as form does not expect it
          {
            max_number_of_allocations: maxAllocations,
            adaptive_allocations: undefined
          } : {})
        }
      }
    };
  }
  return data;
};
exports.formDeserializer = formDeserializer;