"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_UNIFIED_CHAT_COMPLETE_BODY = exports.DEFAULT_TEXT_EMBEDDING_BODY = exports.DEFAULT_TASK_TYPE = exports.DEFAULT_SPARSE_EMBEDDING_BODY = exports.DEFAULT_RERANK_BODY = exports.DEFAULT_PROVIDER = exports.DEFAULT_CHAT_COMPLETE_BODY = exports.DEFAULTS_BY_TASK_TYPE = void 0;
var _constants = require("@kbn/connector-schemas/inference/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CHAT_COMPLETE_BODY = exports.DEFAULT_CHAT_COMPLETE_BODY = {
  input: 'What is Elastic?'
};
const DEFAULT_RERANK_BODY = exports.DEFAULT_RERANK_BODY = {
  input: ['luke', 'like', 'leia', 'chewy', 'r2d2', 'star', 'wars'],
  query: 'star wars main character'
};
const DEFAULT_SPARSE_EMBEDDING_BODY = exports.DEFAULT_SPARSE_EMBEDDING_BODY = {
  input: 'The sky above the port was the color of television tuned to a dead channel.'
};
const DEFAULT_TEXT_EMBEDDING_BODY = exports.DEFAULT_TEXT_EMBEDDING_BODY = {
  input: 'The sky above the port was the color of television tuned to a dead channel.',
  inputType: 'ingest'
};
const DEFAULT_UNIFIED_CHAT_COMPLETE_BODY = exports.DEFAULT_UNIFIED_CHAT_COMPLETE_BODY = {
  body: {
    messages: [{
      role: 'user',
      content: 'Hello world'
    }]
  }
};
const DEFAULTS_BY_TASK_TYPE = exports.DEFAULTS_BY_TASK_TYPE = {
  [_constants.SUB_ACTION.COMPLETION]: DEFAULT_CHAT_COMPLETE_BODY,
  [_constants.SUB_ACTION.UNIFIED_COMPLETION]: DEFAULT_UNIFIED_CHAT_COMPLETE_BODY,
  [_constants.SUB_ACTION.UNIFIED_COMPLETION_STREAM]: DEFAULT_UNIFIED_CHAT_COMPLETE_BODY,
  [_constants.SUB_ACTION.UNIFIED_COMPLETION_ASYNC_ITERATOR]: DEFAULT_UNIFIED_CHAT_COMPLETE_BODY,
  [_constants.SUB_ACTION.RERANK]: DEFAULT_RERANK_BODY,
  [_constants.SUB_ACTION.SPARSE_EMBEDDING]: DEFAULT_SPARSE_EMBEDDING_BODY,
  [_constants.SUB_ACTION.TEXT_EMBEDDING]: DEFAULT_TEXT_EMBEDDING_BODY
};
const DEFAULT_TASK_TYPE = exports.DEFAULT_TASK_TYPE = 'unified_completion';
const DEFAULT_PROVIDER = exports.DEFAULT_PROVIDER = 'elasticsearch';