"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("@kbn/connector-schemas/gemini/constants");
var _constants2 = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/gemini/params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GeminiParamsFields = ({
  actionParams,
  editAction,
  index,
  messageVariables,
  executionMode,
  errors
}) => {
  const {
    subAction,
    subActionParams
  } = actionParams;
  const {
    body,
    model
  } = subActionParams !== null && subActionParams !== void 0 ? subActionParams : {};
  const isTest = (0, _react.useMemo)(() => executionMode === _public.ActionConnectorMode.Test, [executionMode]);
  (0, _react.useEffect)(() => {
    if (!subAction) {
      editAction('subAction', isTest ? _constants.SUB_ACTION.TEST : _constants.SUB_ACTION.RUN, index);
    }
  }, [editAction, index, isTest, subAction]);
  (0, _react.useEffect)(() => {
    if (!subActionParams) {
      editAction('subActionParams', {
        body: _constants2.DEFAULT_BODY
      }, index);
    }
  }, [editAction, index, subActionParams]);
  (0, _react.useEffect)(() => {
    return () => {
      // some gemini specific formatting gets messed up if we do not reset
      // subActionParams on dismount (switching tabs between test and config)
      editAction('subActionParams', undefined, index);
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const editSubActionParams = (0, _react.useCallback)(params => {
    editAction('subActionParams', {
      ...subActionParams,
      ...params
    }, index);
  }, [editAction, index, subActionParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: body,
    label: i18n.BODY,
    ariaLabel: i18n.BODY_DESCRIPTION,
    errors: errors.body,
    onDocumentsChange: json => {
      editSubActionParams({
        body: json.trim()
      });
    },
    onBlur: () => {
      if (!body) {
        editSubActionParams({
          body: ''
        });
      }
    },
    dataTestSubj: "gemini-bodyJsonEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: i18n.MODEL,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Optionally overwrite default model per request. Current support is for the Gemini 1.5 models. For more information, refer to the {geminiAPIModelDocs}.",
      id: "xpack.stackConnectors.components.gemini.modelHelpText",
      values: {
        geminiAPIModelDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "gemini-api-model-doc",
          href: "https://ai.google.dev/models/gemini/",
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 17
          }
        }, `${i18n.gemini} ${i18n.DOCUMENTATION}`)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "gemini-model",
    placeholder: _constants.DEFAULT_MODEL,
    value: model,
    onChange: ev => {
      editSubActionParams({
        model: ev.target.value
      });
    },
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = GeminiParamsFields;
module.exports = exports.default;