"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedEmailOptions = exports.default = exports.EmailParamsFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/email/email_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const noop = () => {};
const getFormattedEmailOptions = (searchValue, previousOptions) => {
  if (!searchValue.trim()) return previousOptions;
  const previousEmails = previousOptions.map(option => option.label);
  const allUniqueEmails = new Set(previousEmails);
  searchValue.split(',').forEach(email => {
    const trimmedEmail = email.trim();
    if (trimmedEmail) allUniqueEmails.add(trimmedEmail);
  });
  const formattedOptions = Array.from(allUniqueEmails).map(email => ({
    label: email
  }));
  return formattedOptions;
};
exports.getFormattedEmailOptions = getFormattedEmailOptions;
const EmailParamsFields = ({
  actionParams,
  editAction,
  index,
  errors,
  messageVariables,
  defaultMessage,
  isLoading,
  isDisabled,
  onBlur = noop,
  showEmailSubjectAndMessage = true,
  useDefaultMessage,
  ruleTypeId
}) => {
  var _errors$subject, _errors$message;
  const {
    to,
    cc,
    bcc,
    subject,
    message
  } = actionParams;
  const toOptions = to ? to.map(label => ({
    label
  })) : [];
  const ccOptions = cc ? cc.map(label => ({
    label
  })) : [];
  const bccOptions = bcc ? bcc.map(label => ({
    label
  })) : [];
  const [addCC, setAddCC] = (0, _react.useState)(false);
  const [addBCC, setAddBCC] = (0, _react.useState)(false);
  const [[isUsingDefault, defaultMessageUsed], setDefaultMessageUsage] = (0, _react.useState)([false, defaultMessage]);
  (0, _react.useEffect)(() => {
    if (useDefaultMessage || !(actionParams !== null && actionParams !== void 0 && actionParams.message) || isUsingDefault && (actionParams === null || actionParams === void 0 ? void 0 : actionParams.message) === defaultMessageUsed && defaultMessageUsed !== defaultMessage) {
      setDefaultMessageUsage([true, defaultMessage]);
      editAction('message', defaultMessage, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [defaultMessage]);
  const isToInvalid = to !== undefined && errors.to !== undefined && Number(errors.to.length) > 0;
  const isSubjectInvalid = subject !== undefined && errors.subject !== undefined && Number(errors.subject.length) > 0;
  const isCCInvalid = errors.cc !== undefined && Number(errors.cc.length) > 0 && cc !== undefined;
  const isBCCInvalid = errors.bcc !== undefined && Number(errors.bcc.length) > 0 && bcc !== undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.to,
    isInvalid: isToInvalid,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.email.recipientTextFieldLabel', {
      defaultMessage: 'To'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }, !addCC && (!cc || (cc === null || cc === void 0 ? void 0 : cc.length) === 0) ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: () => setAddCC(true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Cc",
      id: "xpack.stackConnectors.components.email.addCcButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 19
      }
    })) : null, !addBCC && (!bcc || (bcc === null || bcc === void 0 ? void 0 : bcc.length) === 0) ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: () => setAddBCC(true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Bcc",
      id: "xpack.stackConnectors.components.email.addBccButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 19
      }
    })) : null)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    isInvalid: isToInvalid,
    isLoading: isLoading,
    isDisabled: isDisabled,
    fullWidth: true,
    "data-test-subj": "toEmailAddressInput",
    selectedOptions: toOptions,
    onCreateOption: searchValue => {
      const newOptions = getFormattedEmailOptions(searchValue, toOptions);
      editAction('to', newOptions.map(newOption => newOption.label), index);
    },
    onChange: selectedOptions => {
      editAction('to', selectedOptions.map(selectedOption => selectedOption.label), index);
    },
    onBlur: () => {
      if (!to) {
        editAction('to', [], index);
      }
      onBlur('to');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  })), addCC || cc && (cc === null || cc === void 0 ? void 0 : cc.length) > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.cc,
    isInvalid: isCCInvalid,
    isDisabled: isDisabled,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.email.recipientCopyTextFieldLabel', {
      defaultMessage: 'Cc'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    autoFocus: true,
    noSuggestions: true,
    isInvalid: isCCInvalid,
    isLoading: isLoading,
    fullWidth: true,
    "data-test-subj": "ccEmailAddressInput",
    selectedOptions: ccOptions,
    onCreateOption: searchValue => {
      const newOptions = getFormattedEmailOptions(searchValue, ccOptions);
      editAction('cc', newOptions.map(newOption => newOption.label), index);
    },
    onChange: selectedOptions => {
      editAction('cc', selectedOptions.map(selectedOption => selectedOption.label), index);
    },
    onBlur: () => {
      if (!cc) {
        editAction('cc', [], index);
      }
      onBlur('cc');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  })) : null, addBCC || bcc && (bcc === null || bcc === void 0 ? void 0 : bcc.length) > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.bcc,
    isInvalid: isBCCInvalid,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.email.recipientBccTextFieldLabel', {
      defaultMessage: 'Bcc'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    autoFocus: true,
    noSuggestions: true,
    isInvalid: isBCCInvalid,
    isDisabled: isDisabled,
    isLoading: isLoading,
    fullWidth: true,
    "data-test-subj": "bccEmailAddressInput",
    selectedOptions: bccOptions,
    onCreateOption: searchValue => {
      const newOptions = getFormattedEmailOptions(searchValue, bccOptions);
      editAction('bcc', newOptions.map(newOption => newOption.label), index);
    },
    onChange: selectedOptions => {
      editAction('bcc', selectedOptions.map(selectedOption => selectedOption.label), index);
    },
    onBlur: () => {
      if (!bcc) {
        editAction('bcc', [], index);
      }
      onBlur('bcc');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  })) : null, showEmailSubjectAndMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.subject,
    isInvalid: isSubjectInvalid,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.email.subjectTextFieldLabel', {
      defaultMessage: 'Subject'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'subject',
    inputTargetValue: subject,
    errors: (_errors$subject = errors.subject) !== null && _errors$subject !== void 0 ? _errors$subject : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  })), showEmailSubjectAndMessage && /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'message',
    inputTargetValue: message,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.email.messageTextAreaFieldLabel', {
      defaultMessage: 'Message'
    }),
    errors: (_errors$message = errors.message) !== null && _errors$message !== void 0 ? _errors$message : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.EmailParamsFields = EmailParamsFields;